/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Objects;
import java.util.function.Function;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.groupby.having.HavingSpec;

public class DimFilterHavingSpec
implements HavingSpec {
    private static final boolean DEFAULT_FINALIZE = true;
    private final DimFilter dimFilter;
    private final boolean finalize;
    private final SettableSupplier<ResultRow> rowSupplier = new SettableSupplier();
    private Int2ObjectMap<Function<Object, Object>> finalizers = new Int2ObjectArrayMap();
    private ValueMatcher matcher = null;
    private int evalCount;

    @JsonCreator
    public DimFilterHavingSpec(@JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="finalize") Boolean finalize) {
        this.dimFilter = (DimFilter)Preconditions.checkNotNull((Object)dimFilter, (Object)"filter");
        this.finalize = finalize == null ? true : finalize;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public boolean isFinalize() {
        return this.finalize;
    }

    @Override
    public void setQuery(GroupByQuery query) {
        this.finalizers = new Int2ObjectArrayMap(query.getAggregatorSpecs().size());
        for (AggregatorFactory factory : query.getAggregatorSpecs()) {
            int i = query.getResultRowPositionLookup().getInt((Object)factory.getName());
            this.finalizers.put(i, factory::finalizeComputation);
        }
        this.matcher = this.dimFilter.toFilter().makeMatcher(RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory(query, this.rowSupplier));
    }

    @Override
    public boolean eval(ResultRow row) {
        int oldEvalCount = this.evalCount++;
        if (this.finalize && !this.finalizers.isEmpty()) {
            ResultRow finalizedCopy = row.copy();
            for (Int2ObjectMap.Entry entry : this.finalizers.int2ObjectEntrySet()) {
                finalizedCopy.set(entry.getIntKey(), ((Function)entry.getValue()).apply(row.get(entry.getIntKey())));
            }
            this.rowSupplier.set((Object)finalizedCopy);
        } else {
            this.rowSupplier.set((Object)row);
        }
        boolean retVal = this.matcher.matches();
        if (this.evalCount != oldEvalCount + 1) {
            throw new IllegalStateException("concurrent 'eval' calls not permitted!");
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimFilterHavingSpec that = (DimFilterHavingSpec)o;
        return this.finalize == that.finalize && Objects.equals(this.dimFilter, that.dimFilter);
    }

    public int hashCode() {
        return Objects.hash(this.dimFilter, this.finalize);
    }

    public String toString() {
        return "DimFilterHavingSpec{dimFilter=" + this.dimFilter + ", finalize=" + this.finalize + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(3).appendCacheable(this.dimFilter).appendByte((byte)(this.isFinalize() ? 1 : 0)).build();
    }
}

