/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.List;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryExecutor;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.search.SearchStrategySelector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;

public class SearchQueryRunner
implements QueryRunner<Result<SearchResultValue>> {
    public static final SearchColumnSelectorStrategyFactory SEARCH_COLUMN_SELECTOR_STRATEGY_FACTORY = new SearchColumnSelectorStrategyFactory();
    private final Segment segment;
    private final SearchStrategySelector strategySelector;

    public SearchQueryRunner(Segment segment, SearchStrategySelector strategySelector) {
        this.segment = segment;
        this.strategySelector = strategySelector;
    }

    @Override
    public Sequence<Result<SearchResultValue>> run(QueryPlus<Result<SearchResultValue>> queryPlus, ResponseContext responseContext) {
        Query<Result<SearchResultValue>> input = queryPlus.getQuery();
        if (!(input instanceof SearchQuery)) {
            throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SearchQuery.class});
        }
        SearchQuery query = (SearchQuery)input;
        List<SearchQueryExecutor> plan = this.strategySelector.strategize(query).getExecutionPlan(query, this.segment);
        Object2IntRBTreeMap retVal = new Object2IntRBTreeMap(query.getSort().getComparator());
        retVal.defaultReturnValue(0);
        int remain = query.getLimit();
        for (SearchQueryExecutor executor : plan) {
            retVal.putAll(executor.execute(remain));
            remain -= retVal.size();
        }
        return SearchQueryRunner.makeReturnResult(this.segment, query.getLimit(), (Object2IntRBTreeMap<SearchHit>)retVal);
    }

    private static Sequence<Result<SearchResultValue>> makeReturnResult(Segment segment, int limit, Object2IntRBTreeMap<SearchHit> retVal) {
        Iterable source = Iterables.transform((Iterable)retVal.object2IntEntrySet(), (Function)new Function<Object2IntMap.Entry<SearchHit>, SearchHit>(){

            public SearchHit apply(Object2IntMap.Entry<SearchHit> input) {
                SearchHit hit = (SearchHit)input.getKey();
                return new SearchHit(hit.getDimension(), hit.getValue(), input.getIntValue());
            }
        });
        return Sequences.simple((Iterable)ImmutableList.of(new Result<SearchResultValue>(segment.getDataInterval().getStart(), new SearchResultValue(Lists.newArrayList((Iterable)new FunctionalIterable(source).limit(limit))))));
    }

    public static class DoubleSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
        @Override
        public void updateSearchResultSet(String outputName, BaseDoubleColumnValueSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            String dimVal;
            if (selector != null && searchQuerySpec.accept(dimVal = String.valueOf(selector.getDouble()))) {
                set.addTo((Object)new SearchHit(outputName, dimVal), 1);
            }
        }
    }

    public static class FloatSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<BaseFloatColumnValueSelector> {
        @Override
        public void updateSearchResultSet(String outputName, BaseFloatColumnValueSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            String dimVal;
            if (selector != null && searchQuerySpec.accept(dimVal = String.valueOf(selector.getFloat()))) {
                set.addTo((Object)new SearchHit(outputName, dimVal), 1);
            }
        }
    }

    public static class LongSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<BaseLongColumnValueSelector> {
        @Override
        public void updateSearchResultSet(String outputName, BaseLongColumnValueSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            String dimVal;
            if (selector != null && searchQuerySpec.accept(dimVal = String.valueOf(selector.getLong()))) {
                set.addTo((Object)new SearchHit(outputName, dimVal), 1);
            }
        }
    }

    public static class StringSearchColumnSelectorStrategy
    implements SearchColumnSelectorStrategy<DimensionSelector> {
        @Override
        public void updateSearchResultSet(String outputName, DimensionSelector selector, SearchQuerySpec searchQuerySpec, int limit, Object2IntRBTreeMap<SearchHit> set) {
            if (!DimensionSelector.isNilSelector(selector)) {
                IndexedInts row = selector.getRow();
                int rowSize = row.size();
                for (int i = 0; i < rowSize; ++i) {
                    String dimVal = selector.lookupName(row.get(i));
                    if (!searchQuerySpec.accept(dimVal)) continue;
                    set.addTo((Object)new SearchHit(outputName, dimVal), 1);
                    if (set.size() < limit) continue;
                    return;
                }
            }
        }
    }

    public static interface SearchColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public void updateSearchResultSet(String var1, ValueSelectorType var2, SearchQuerySpec var3, int var4, Object2IntRBTreeMap<SearchHit> var5);
    }

    private static class SearchColumnSelectorStrategyFactory
    implements ColumnSelectorStrategyFactory<SearchColumnSelectorStrategy> {
        private SearchColumnSelectorStrategyFactory() {
        }

        @Override
        public SearchColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    return new StringSearchColumnSelectorStrategy();
                }
                case LONG: {
                    return new LongSearchColumnSelectorStrategy();
                }
                case FLOAT: {
                    return new FloatSearchColumnSelectorStrategy();
                }
                case DOUBLE: {
                    return new DoubleSearchColumnSelectorStrategy();
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }
    }
}

