/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.select;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.joda.time.DateTime;

public class EventHolder {
    public static final String TIMESTAMP_KEY = "timestamp";
    private final String segmentId;
    private final int offset;
    private final Map<String, Object> event;

    @JsonCreator
    public EventHolder(@JsonProperty(value="segmentId") String segmentId, @JsonProperty(value="offset") int offset, @JsonProperty(value="event") Map<String, Object> event) {
        this.segmentId = segmentId;
        this.offset = offset;
        this.event = event;
    }

    public DateTime getTimestamp() {
        Object retVal = this.event.get(TIMESTAMP_KEY);
        if (retVal instanceof Long) {
            return DateTimes.utc((long)((Long)retVal));
        }
        if (retVal instanceof String) {
            return DateTimes.of((String)((String)retVal));
        }
        if (retVal instanceof DateTime) {
            return (DateTime)retVal;
        }
        throw new ISE("Do not understand format [%s]", new Object[]{retVal.getClass()});
    }

    @JsonProperty
    public String getSegmentId() {
        return this.segmentId;
    }

    @JsonProperty
    public int getOffset() {
        return this.offset;
    }

    @JsonProperty
    public Map<String, Object> getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventHolder that = (EventHolder)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (!Maps.difference(this.event, ((EventHolder)o).event).areEqual()) {
            return false;
        }
        return !(this.segmentId != null ? !this.segmentId.equals(that.segmentId) : that.segmentId != null);
    }

    public int hashCode() {
        int result = this.segmentId != null ? this.segmentId.hashCode() : 0;
        result = 31 * result + this.offset;
        result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventHolder{segmentId='" + this.segmentId + '\'' + ", offset=" + this.offset + ", event=" + this.event + '}';
    }
}

