/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.Capabilities;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexColumnSelectorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IncrementalIndexStorageAdapter
implements StorageAdapter {
    final IncrementalIndex<?> index;

    public IncrementalIndexStorageAdapter(IncrementalIndex<?> index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.index.getDimensionNames());
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.index.getMetricNames();
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension.equals("__time")) {
            return Integer.MAX_VALUE;
        }
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(dimension);
        if (desc == null) {
            return 0;
        }
        DimensionIndexer indexer = desc.getIndexer();
        int cardinality = indexer.getCardinality();
        return cardinality != -1 ? cardinality : Integer.MAX_VALUE;
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public DateTime getMinTime() {
        return this.index.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.index.getMaxTime();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer indexer = desc.getIndexer();
        return indexer.getMinValue();
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer indexer = desc.getIndexer();
        return indexer.getMaxValue();
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(false).build();
    }

    @Override
    public ColumnCapabilities getColumnCapabilities(String column) {
        ColumnCapabilities capabilitiesFromIndex = this.index.getCapabilities(column);
        IncrementalIndex.DimensionDesc dimensionDesc = this.index.getDimension(column);
        if (dimensionDesc != null && dimensionDesc.getCapabilities().getType() == ValueType.STRING) {
            ColumnCapabilitiesImpl retVal = ColumnCapabilitiesImpl.copyOf(capabilitiesFromIndex);
            retVal.setHasMultipleValues(true);
            return retVal;
        }
        return capabilitiesFromIndex;
    }

    @Override
    public String getColumnTypeName(String column) {
        String metricType = this.index.getMetricType(column);
        if (metricType != null) {
            return metricType;
        }
        ColumnCapabilities columnCapabilities = this.getColumnCapabilities(column);
        if (columnCapabilities != null) {
            return columnCapabilities.getType().toString();
        }
        return null;
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.index.getMaxIngestedEventTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        if (this.index.isEmpty()) {
            return Sequences.empty();
        }
        Interval dataInterval = new Interval((ReadableInstant)this.getMinTime(), (ReadableInstant)gran.bucketEnd(this.getMaxTime()));
        if (!interval.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        Interval actualInterval = interval.overlap((ReadableInterval)dataInterval);
        Iterable intervals = gran.getIterable(actualInterval);
        if (descending) {
            intervals = Lists.reverse((List)ImmutableList.copyOf((Iterable)intervals));
        }
        return Sequences.simple((Iterable)intervals).map(i -> new IncrementalIndexCursor(virtualColumns, descending, filter, (Interval)i, actualInterval, gran));
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    private class IncrementalIndexCursor
    implements Cursor {
        private IncrementalIndexRowHolder currEntry = new IncrementalIndexRowHolder();
        private final ColumnSelectorFactory columnSelectorFactory;
        private final ValueMatcher filterMatcher;
        private final int maxRowIndex;
        private Iterator<IncrementalIndexRow> baseIter;
        private Iterable<IncrementalIndexRow> cursorIterable;
        private boolean emptyRange;
        private final DateTime time;
        private int numAdvanced;
        private boolean done;

        IncrementalIndexCursor(VirtualColumns virtualColumns, boolean descending, Filter filter, Interval interval, Interval actualInterval, Granularity gran) {
            this.columnSelectorFactory = new IncrementalIndexColumnSelectorFactory(IncrementalIndexStorageAdapter.this, virtualColumns, descending, this.currEntry);
            this.maxRowIndex = IncrementalIndexStorageAdapter.this.index.getLastRowIndex();
            this.filterMatcher = filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(this.columnSelectorFactory);
            this.numAdvanced = -1;
            long timeStart = Math.max(interval.getStartMillis(), actualInterval.getStartMillis());
            this.cursorIterable = IncrementalIndexStorageAdapter.this.index.getFacts().timeRangeIterable(descending, timeStart, Math.min(actualInterval.getEndMillis(), gran.increment(interval.getStart()).getMillis()));
            this.emptyRange = !this.cursorIterable.iterator().hasNext();
            this.time = gran.toDateTime(interval.getStartMillis());
            this.reset();
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public DateTime getTime() {
            return this.time;
        }

        @Override
        public void advance() {
            if (!this.baseIter.hasNext()) {
                this.done = true;
                return;
            }
            while (this.baseIter.hasNext()) {
                BaseQuery.checkInterrupted();
                IncrementalIndexRow entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) continue;
                this.currEntry.set(entry);
                if (!this.filterMatcher.matches()) continue;
                return;
            }
            this.done = true;
        }

        @Override
        public void advanceUninterruptibly() {
            if (!this.baseIter.hasNext()) {
                this.done = true;
                return;
            }
            while (this.baseIter.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                IncrementalIndexRow entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) continue;
                this.currEntry.set(entry);
                if (!this.filterMatcher.matches()) continue;
                return;
            }
            this.done = true;
        }

        @Override
        public void advanceTo(int offset) {
            for (int count = 0; count < offset && !this.isDone(); ++count) {
                this.advance();
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.baseIter = this.cursorIterable.iterator();
            if (this.numAdvanced == -1) {
                this.numAdvanced = 0;
            } else {
                Iterators.advance(this.baseIter, (int)this.numAdvanced);
            }
            BaseQuery.checkInterrupted();
            boolean foundMatched = false;
            while (this.baseIter.hasNext()) {
                IncrementalIndexRow entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) {
                    ++this.numAdvanced;
                    continue;
                }
                this.currEntry.set(entry);
                if (this.filterMatcher.matches()) {
                    foundMatched = true;
                    break;
                }
                ++this.numAdvanced;
            }
            this.done = !foundMatched && (this.emptyRange || !this.baseIter.hasNext());
        }

        private boolean beyondMaxRowIndex(int rowIndex) {
            return rowIndex > this.maxRowIndex;
        }
    }
}

