/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.vector.ReadableVectorOffset;

public class VectorSelectorUtils {
    @Nullable
    public static boolean[] populateNullVector(@Nullable boolean[] nullVector, ReadableVectorOffset offset, ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            return null;
        }
        boolean[] retVal = nullVector != null ? nullVector : new boolean[offset.getMaxVectorSize()];
        if (offset.isContiguous()) {
            for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                retVal[i] = nullValueBitmap.get(i + offset.getStartOffset());
            }
        } else {
            for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                retVal[i] = nullValueBitmap.get(offset.getOffsets()[i]);
            }
        }
        return retVal;
    }
}

