/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.MultiValueExpressionDimensionSelector;
import org.apache.druid.segment.virtual.RowBasedExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleLongInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputDimensionSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ColumnValueSelector makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                ExprEval eval = (ExprEval)baseSelector.getObject();
                if (eval.isArray()) {
                    return Arrays.stream(eval.asStringArray()).map(NullHandling::emptyToNullIfNeeded).collect(Collectors.toList());
                }
                return eval.value();
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        Expr.BindingDetails exprDetails = expression.analyzeInputs();
        Parser.validateExpr((Expr)expression, (Expr.BindingDetails)exprDetails);
        List columns = exprDetails.getRequiredBindingsList();
        if (columns.size() == 1) {
            String column = (String)Iterables.getOnlyElement((Iterable)columns);
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(column);
            if (capabilities != null && capabilities.getType() == ValueType.LONG) {
                return new SingleLongInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeColumnValueSelector(column), expression, !"__time".equals(column));
            }
            if (capabilities != null && capabilities.getType() == ValueType.STRING && capabilities.isDictionaryEncoded() && capabilities.isComplete() && !capabilities.hasMultipleValues() && exprDetails.getArrayBindings().isEmpty()) {
                return new SingleStringInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
            }
        }
        Pair<Set<String>, Set<String>> arrayUsage = ExpressionSelectors.examineColumnSelectorFactoryArrays(columnSelectorFactory, exprDetails, columns);
        Set actualArrays = (Set)arrayUsage.lhs;
        Set unknownIfArrays = (Set)arrayUsage.rhs;
        List needsApplied = columns.stream().filter(c -> actualArrays.contains(c) && !exprDetails.getArrayBindings().contains(c)).collect(Collectors.toList());
        Expr finalExpr = needsApplied.size() > 0 ? Parser.applyUnappliedBindings((Expr)expression, (Expr.BindingDetails)exprDetails, needsApplied) : expression;
        Expr.ObjectBinding bindings = ExpressionSelectors.createBindings(exprDetails, columnSelectorFactory);
        if (bindings.equals(ExprUtils.nilBindings())) {
            return new ConstantExprEvalSelector(expression.eval(bindings));
        }
        if (unknownIfArrays.size() > 0) {
            return new RowBasedExpressionColumnValueSelector(finalExpr, exprDetails, bindings, unknownIfArrays);
        }
        return new ExpressionColumnValueSelector(finalExpr, bindings);
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, final ExtractionFn extractionFn) {
        boolean multiVal;
        String column;
        ColumnCapabilities capabilities;
        Expr.BindingDetails exprDetails = expression.analyzeInputs();
        Parser.validateExpr((Expr)expression, (Expr.BindingDetails)exprDetails);
        List columns = exprDetails.getRequiredBindingsList();
        if (!(columns.size() != 1 || (capabilities = columnSelectorFactory.getColumnCapabilities(column = (String)Iterables.getOnlyElement((Iterable)columns))) == null || capabilities.getType() != ValueType.STRING || !capabilities.isDictionaryEncoded() || !capabilities.isComplete() || exprDetails.hasInputArrays() || exprDetails.isOutputArray() || capabilities.hasMultipleValues() && exprDetails.getFreeVariables().size() != 1)) {
            return new SingleStringInputDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ValueType.STRING)), expression);
        }
        Pair<Set<String>, Set<String>> arrayUsage = ExpressionSelectors.examineColumnSelectorFactoryArrays(columnSelectorFactory, exprDetails, columns);
        Set actualArrays = (Set)arrayUsage.lhs;
        Set unknownIfArrays = (Set)arrayUsage.rhs;
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        boolean bl = multiVal = actualArrays.size() > 0 || exprDetails.getArrayBindings().size() > 0 || unknownIfArrays.size() > 0;
        if (baseSelector instanceof ConstantExprEvalSelector) {
            return DimensionSelector.constant(((ExprEval)baseSelector.getObject()).asString(), extractionFn);
        }
        if (baseSelector instanceof NilColumnValueSelector) {
            return DimensionSelector.constant(null);
        }
        if (extractionFn == null) {
            if (multiVal) {
                return new MultiValueExpressionDimensionSelector(baseSelector);
            }
            class DefaultExpressionDimensionSelector
            extends BaseSingleValueDimensionSelector {
                final /* synthetic */ ColumnValueSelector val$baseSelector;

                DefaultExpressionDimensionSelector(ColumnValueSelector columnValueSelector) {
                    this.val$baseSelector = columnValueSelector;
                }

                @Override
                protected String getValue() {
                    return NullHandling.emptyToNullIfNeeded((String)((ExprEval)this.val$baseSelector.getObject()).asString());
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", this.val$baseSelector);
                }
            }
            return new DefaultExpressionDimensionSelector(baseSelector);
        }
        if (multiVal) {
            class ExtractionMultiValueDimensionSelector
            extends MultiValueExpressionDimensionSelector {
                ExtractionMultiValueDimensionSelector() {
                    super(columnValueSelector);
                }

                @Override
                String getValue(ExprEval evaluated) {
                    assert (!evaluated.isArray());
                    return extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)evaluated.asString()));
                }

                @Override
                List<String> getArray(ExprEval evaluated) {
                    assert (evaluated.isArray());
                    return Arrays.stream(evaluated.asStringArray()).map(x -> extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)x))).collect(Collectors.toList());
                }

                @Override
                String getArrayValue(ExprEval evaluated, int i) {
                    assert (evaluated.isArray());
                    String[] stringArray = evaluated.asStringArray();
                    assert (i < stringArray.length);
                    return extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)stringArray[i]));
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("baseSelector", baseSelector);
                    inspector.visit("extractionFn", extractionFn);
                }
            }
            return new ExtractionMultiValueDimensionSelector();
        }
        class ExtractionExpressionDimensionSelector
        extends BaseSingleValueDimensionSelector {
            ExtractionExpressionDimensionSelector() {
            }

            @Override
            protected String getValue() {
                return extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)((ExprEval)baseSelector.getObject()).asString()));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
                inspector.visit("extractionFn", extractionFn);
            }
        }
        return new ExtractionExpressionDimensionSelector();
    }

    private static Expr.ObjectBinding createBindings(Expr.BindingDetails bindingDetails, ColumnSelectorFactory columnSelectorFactory) {
        HashMap suppliers = new HashMap();
        List columns = bindingDetails.getRequiredBindingsList();
        for (String columnName : columns) {
            Object supplier;
            ColumnValueSelector selector;
            boolean multiVal;
            ColumnCapabilities columnCapabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            ValueType nativeType = columnCapabilities != null ? columnCapabilities.getType() : null;
            boolean bl = multiVal = columnCapabilities != null && columnCapabilities.hasMultipleValues();
            if (nativeType == ValueType.FLOAT) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableSupplier(selector, selector::getFloat);
            } else if (nativeType == ValueType.LONG) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableSupplier(selector, selector::getLong);
            } else if (nativeType == ValueType.DOUBLE) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableSupplier(selector, selector::getDouble);
            } else {
                supplier = nativeType == ValueType.STRING ? ExpressionSelectors.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName)), multiVal) : (nativeType == null ? ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName)) : null);
            }
            if (supplier == null) continue;
            suppliers.put(columnName, (Supplier)supplier);
        }
        if (suppliers.isEmpty()) {
            return ExprUtils.nilBindings();
        }
        if (suppliers.size() == 1 && columns.size() == 1) {
            String column = (String)Iterables.getOnlyElement(suppliers.keySet());
            Supplier supplier = (Supplier)Iterables.getOnlyElement(suppliers.values());
            return identifierName -> {
                assert (column.equals(identifierName));
                return supplier.get();
            };
        }
        return Parser.withSuppliers(suppliers);
    }

    private static <T> Supplier<T> makeNullableSupplier(ColumnValueSelector selector, Supplier<T> supplier) {
        if (NullHandling.replaceWithDefault()) {
            return supplier;
        }
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return supplier.get();
        };
    }

    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector, boolean coerceArray) {
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 1 && !coerceArray) {
                return selector.lookupName(row.get(0));
            }
            if (row.size() == 0) {
                return new String[]{null};
            }
            String[] strings = new String[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                strings[i] = selector.lookupName(row.get(i));
            }
            return strings;
        };
    }

    @Nullable
    static Supplier<Object> supplierFromObjectSelector(BaseObjectColumnValueSelector<?> selector) {
        Class<Object> clazz;
        block7: {
            block6: {
                if (selector instanceof NilColumnValueSelector) {
                    return null;
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block6;
                if (!String.class.isAssignableFrom(clazz)) break block7;
            }
            return selector::getObject;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val instanceof Number || val instanceof String) {
                    return val;
                }
                if (val instanceof List) {
                    return ExpressionSelectors.coerceListDimToStringArray((List)val);
                }
                return null;
            };
        }
        if (clazz.isAssignableFrom(List.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val != null) {
                    return ExpressionSelectors.coerceListDimToStringArray((List)val);
                }
                return null;
            };
        }
        return null;
    }

    private static Object coerceListDimToStringArray(List val) {
        A[] arrayVal = val.stream().map(x -> x != null ? x.toString() : x).toArray(String[]::new);
        if (arrayVal.length > 0) {
            return arrayVal;
        }
        return new String[]{null};
    }

    private static Pair<Set<String>, Set<String>> examineColumnSelectorFactoryArrays(ColumnSelectorFactory columnSelectorFactory, Expr.BindingDetails exprDetails, List<String> columns) {
        HashSet<String> actualArrays = new HashSet<String>();
        HashSet<String> unknownIfArrays = new HashSet<String>();
        for (String column : columns) {
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(column);
            if (capabilities != null) {
                if (capabilities.hasMultipleValues()) {
                    actualArrays.add(column);
                    continue;
                }
                if (capabilities.isComplete() || !capabilities.getType().equals((Object)ValueType.STRING) || exprDetails.getArrayBindings().contains(column)) continue;
                unknownIfArrays.add(column);
                continue;
            }
            unknownIfArrays.add(column);
        }
        return new Pair(actualArrays, unknownIfArrays);
    }
}

