/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.concurrent.ExecutorServiceConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.utils.JvmUtils;
import org.skife.config.Config;

public abstract class DruidProcessingConfig
extends ExecutorServiceConfig
implements ColumnConfig {
    private static final Logger log = new Logger(DruidProcessingConfig.class);
    public static final int DEFAULT_NUM_MERGE_BUFFERS = -1;
    public static final int DEFAULT_PROCESSING_BUFFER_SIZE_BYTES = -1;
    public static final int MAX_DEFAULT_PROCESSING_BUFFER_SIZE_BYTES = 0x40000000;
    private AtomicReference<Integer> computedBufferSizeBytes = new AtomicReference();

    @Config(value={"druid.computation.buffer.size", "${base_path}.buffer.sizeBytes"})
    public int intermediateComputeSizeBytesConfigured() {
        return -1;
    }

    public int intermediateComputeSizeBytes() {
        long directSizeBytes;
        int sizeBytesConfigured = this.intermediateComputeSizeBytesConfigured();
        if (sizeBytesConfigured != -1) {
            return sizeBytesConfigured;
        }
        if (this.computedBufferSizeBytes.get() != null) {
            return this.computedBufferSizeBytes.get();
        }
        try {
            directSizeBytes = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            log.info("Detected max direct memory size of [%,d] bytes", new Object[]{directSizeBytes});
        }
        catch (UnsupportedOperationException e) {
            directSizeBytes = DruidProcessingConfig.computeMaxMemoryFromMaxHeapSize();
            log.info("Defaulting to at most [%,d] bytes (25%% of max heap size) of direct memory for computation buffers", new Object[]{directSizeBytes});
        }
        int numProcessingThreads = this.getNumThreads();
        int numMergeBuffers = this.getNumMergeBuffers();
        int totalNumBuffers = numMergeBuffers + numProcessingThreads;
        int sizePerBuffer = (int)((double)directSizeBytes / (double)(totalNumBuffers + 1));
        int computedSizePerBuffer = Math.min(sizePerBuffer, 0x40000000);
        if (this.computedBufferSizeBytes.compareAndSet(null, computedSizePerBuffer)) {
            log.info("Auto sizing buffers to [%,d] bytes each for [%,d] processing and [%,d] merge buffers", new Object[]{computedSizePerBuffer, numProcessingThreads, numMergeBuffers});
        }
        return computedSizePerBuffer;
    }

    public static long computeMaxMemoryFromMaxHeapSize() {
        return Runtime.getRuntime().maxMemory() / 4L;
    }

    @Config(value={"druid.computation.buffer.poolCacheMaxCount", "${base_path}.buffer.poolCacheMaxCount"})
    public int poolCacheMaxCount() {
        return Integer.MAX_VALUE;
    }

    @Config(value={"${base_path}.numThreads"})
    public int getNumThreadsConfigured() {
        return -1;
    }

    public int getNumMergeBuffers() {
        int numMergeBuffersConfigured = this.getNumMergeBuffersConfigured();
        if (numMergeBuffersConfigured != -1) {
            return numMergeBuffersConfigured;
        }
        return Math.max(2, this.getNumThreads() / 4);
    }

    @Config(value={"${base_path}.numMergeBuffers"})
    public int getNumMergeBuffersConfigured() {
        return -1;
    }

    @Override
    @Config(value={"${base_path}.columnCache.sizeBytes"})
    public int columnCacheSizeBytes() {
        return 0;
    }

    @Config(value={"${base_path}.fifo"})
    public boolean isFifo() {
        return false;
    }

    @Config(value={"${base_path}.tmpDir"})
    public String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }
}

