/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.LongSumAggregator;
import org.apache.druid.query.aggregation.NullableAggregatorFactory;
import org.apache.druid.query.aggregation.StringColumnLongAggregatorWrapper;
import org.apache.druid.query.aggregation.StringColumnLongBufferAggregatorWrapper;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public abstract class SimpleLongAggregatorFactory
extends NullableAggregatorFactory<ColumnValueSelector> {
    protected final String name;
    @Nullable
    protected final String fieldName;
    @Nullable
    protected final String expression;
    protected final ExprMacroTable macroTable;
    protected final Supplier<Expr> fieldExpression;

    public SimpleLongAggregatorFactory(ExprMacroTable macroTable, String name, @Nullable String fieldName, @Nullable String expression) {
        this.macroTable = macroTable;
        this.name = name;
        this.fieldName = fieldName;
        this.expression = expression;
        this.fieldExpression = Suppliers.memoize(() -> expression == null ? null : Parser.parse((String)expression, (ExprMacroTable)macroTable));
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkArgument((boolean)(fieldName == null ^ expression == null), (Object)"Must have a valid, non-null fieldName or expression");
    }

    @Override
    protected Aggregator factorize(ColumnSelectorFactory metricFactory, ColumnValueSelector selector) {
        if (this.shouldUseStringColumnAggregatorWrapper(metricFactory)) {
            return new StringColumnLongAggregatorWrapper(selector, this::buildAggregator, this.nullValue());
        }
        return this.buildAggregator(selector);
    }

    @Override
    protected BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, ColumnValueSelector selector) {
        if (this.shouldUseStringColumnAggregatorWrapper(metricFactory)) {
            return new StringColumnLongBufferAggregatorWrapper(selector, this::buildBufferAggregator, this.nullValue());
        }
        return this.buildBufferAggregator(selector);
    }

    @Override
    protected ColumnValueSelector selector(ColumnSelectorFactory metricFactory) {
        return AggregatorUtil.makeColumnValueSelectorWithLongDefault(metricFactory, this.fieldName, (Expr)this.fieldExpression.get(), this.nullValue());
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Comparator getComparator() {
        return LongSumAggregator.COMPARATOR;
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldName != null ? Collections.singletonList(this.fieldName) : ((Expr)this.fieldExpression.get()).analyzeInputs().getRequiredBindingsList();
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.expression, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleLongAggregatorFactory that = (SimpleLongAggregatorFactory)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    private boolean shouldUseStringColumnAggregatorWrapper(ColumnSelectorFactory columnSelectorFactory) {
        if (this.fieldName != null) {
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(this.fieldName);
            return capabilities != null && capabilities.getType() == ValueType.STRING;
        }
        return false;
    }

    protected abstract long nullValue();

    protected abstract Aggregator buildAggregator(BaseLongColumnValueSelector var1);

    protected abstract BufferAggregator buildBufferAggregator(BaseLongColumnValueSelector var1);
}

