/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class StringFirstAggregator
implements Aggregator {
    private final BaseObjectColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    private final int maxStringBytes;
    protected long firstTime;
    protected String firstValue;

    public StringFirstAggregator(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector valueSelector, int maxStringBytes) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.maxStringBytes = maxStringBytes;
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = null;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            Object value = this.valueSelector.getObject();
            if (value != null) {
                if (value instanceof String) {
                    this.firstValue = (String)value;
                } else if (value instanceof SerializablePairLongString) {
                    this.firstValue = (String)((SerializablePairLongString)((Object)value)).rhs;
                } else {
                    throw new ISE("Try to aggregate unsuported class type [%s].Supported class types: String or SerializablePairLongString", new Object[]{value.getClass().getName()});
                }
                if (this.firstValue != null && this.firstValue.length() > this.maxStringBytes) {
                    this.firstValue = this.firstValue.substring(0, this.maxStringBytes);
                }
            } else {
                this.firstValue = null;
            }
        }
    }

    @Override
    public Object get() {
        return new SerializablePairLongString(this.firstTime, this.firstValue);
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getLong()");
    }

    @Override
    public double getDouble() {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }
}

