/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongLastAggregator
implements Aggregator {
    private final BaseLongColumnValueSelector valueSelector;
    private final BaseLongColumnValueSelector timeSelector;
    protected long lastTime;
    protected long lastValue;

    public LongLastAggregator(BaseLongColumnValueSelector timeSelector, BaseLongColumnValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.lastTime = Long.MIN_VALUE;
        this.lastValue = 0L;
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            this.lastValue = this.valueSelector.getLong();
        }
    }

    @Override
    public double getDouble() {
        return this.lastValue;
    }

    @Override
    public Object get() {
        return new SerializablePair((Object)this.lastTime, (Object)this.lastValue);
    }

    @Override
    public float getFloat() {
        return this.lastValue;
    }

    @Override
    public long getLong() {
        return this.lastValue;
    }

    @Override
    public void close() {
    }
}

