/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.inject.Inject;
import java.io.Closeable;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.CloseQuietly;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryLimitRowIterator;
import org.apache.druid.query.scan.ScanResultValue;

public class ScanQueryQueryToolChest
extends QueryToolChest<ScanResultValue, ScanQuery> {
    private static final TypeReference<ScanResultValue> TYPE_REFERENCE = new TypeReference<ScanResultValue>(){};
    private final ScanQueryConfig scanQueryConfig;
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public ScanQueryQueryToolChest(ScanQueryConfig scanQueryConfig, GenericQueryMetricsFactory queryMetricsFactory) {
        this.scanQueryConfig = scanQueryConfig;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<ScanResultValue> mergeResults(final QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> {
            ScanQuery scanQuery = ((ScanQuery)queryPlus.getQuery()).withNonNullLegacy(this.scanQueryConfig);
            final QueryPlus<ScanResultValue> queryPlusWithNonNullLegacy = queryPlus.withQuery(scanQuery);
            if (scanQuery.getScanRowsLimit() == Long.MAX_VALUE) {
                return runner.run(queryPlusWithNonNullLegacy, responseContext);
            }
            return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ScanResultValue, ScanQueryLimitRowIterator>(){

                public ScanQueryLimitRowIterator make() {
                    return new ScanQueryLimitRowIterator(runner, queryPlusWithNonNullLegacy, responseContext);
                }

                public void cleanup(ScanQueryLimitRowIterator iterFromMake) {
                    CloseQuietly.close((Closeable)((Object)iterFromMake));
                }
            });
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(ScanQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<ScanResultValue, ScanResultValue> makePreComputeManipulatorFn(ScanQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<ScanResultValue> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<ScanResultValue> preMergeQueryDecoration(QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> {
            ScanQuery scanQuery = (ScanQuery)queryPlus.getQuery();
            if (scanQuery.getFilter() != null) {
                scanQuery = scanQuery.withDimFilter(scanQuery.getFilter().optimize());
                queryPlus = queryPlus.withQuery(scanQuery);
            }
            return runner.run(queryPlus, responseContext);
        };
    }
}

