/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.select;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.select.SelectQuery;
import org.apache.druid.query.select.SelectQueryEngine;
import org.apache.druid.query.select.SelectQueryQueryToolChest;
import org.apache.druid.query.select.SelectResultValue;
import org.apache.druid.segment.Segment;

public class SelectQueryRunnerFactory
implements QueryRunnerFactory<Result<SelectResultValue>, SelectQuery> {
    private final SelectQueryQueryToolChest toolChest;
    private final SelectQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public SelectQueryRunnerFactory(SelectQueryQueryToolChest toolChest, SelectQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> createRunner(Segment segment) {
        return new SelectQueryRunner(this.engine, segment);
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SelectResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<SelectResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<SelectResultValue>, SelectQuery> getToolchest() {
        return this.toolChest;
    }

    private static class SelectQueryRunner
    implements QueryRunner<Result<SelectResultValue>> {
        private final SelectQueryEngine engine;
        private final Segment segment;

        private SelectQueryRunner(SelectQueryEngine engine, Segment segment) {
            this.engine = engine;
            this.segment = segment;
        }

        @Override
        public Sequence<Result<SelectResultValue>> run(QueryPlus<Result<SelectResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<SelectResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof SelectQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SelectQuery.class});
            }
            return this.engine.process((SelectQuery)input, this.segment);
        }
    }
}

