/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Supplier;
import com.ning.compress.BufferRecycler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.java.util.common.logger.Logger;

public class CompressedPools {
    private static final Logger log = new Logger(CompressedPools.class);
    public static final int BUFFER_SIZE = 65536;
    private static final NonBlockingPool<BufferRecycler> BUFFER_RECYCLER_POOL = new StupidPool("bufferRecyclerPool", (Supplier)new Supplier<BufferRecycler>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public BufferRecycler get() {
            log.info("Allocating new bufferRecycler[%,d]", new Object[]{this.counter.incrementAndGet()});
            return new BufferRecycler();
        }
    });
    private static final NonBlockingPool<byte[]> OUTPUT_BYTES_POOL = new StupidPool("outputBytesPool", (Supplier)new Supplier<byte[]>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public byte[] get() {
            log.info("Allocating new outputBytesPool[%,d]", new Object[]{this.counter.incrementAndGet()});
            return new byte[65536];
        }
    });
    private static final NonBlockingPool<ByteBuffer> BIG_ENDIAN_BYTE_BUF_POOL = new StupidPool("bigEndByteBufPool", (Supplier)new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ByteBuffer get() {
            log.info("Allocating new bigEndByteBuf[%,d]", new Object[]{this.counter.incrementAndGet()});
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.BIG_ENDIAN);
        }
    });
    private static final NonBlockingPool<ByteBuffer> LITTLE_ENDIAN_BYTE_BUF_POOL = new StupidPool("littleEndByteBufPool", (Supplier)new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ByteBuffer get() {
            log.info("Allocating new littleEndByteBuf[%,d]", new Object[]{this.counter.incrementAndGet()});
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.LITTLE_ENDIAN);
        }
    });

    public static ResourceHolder<BufferRecycler> getBufferRecycler() {
        return BUFFER_RECYCLER_POOL.take();
    }

    public static ResourceHolder<byte[]> getOutputBytes() {
        return OUTPUT_BYTES_POOL.take();
    }

    public static ResourceHolder<ByteBuffer> getByteBuf(ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return LITTLE_ENDIAN_BYTE_BUF_POOL.take();
        }
        return BIG_ENDIAN_BYTE_BUF_POOL.take();
    }
}

