/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;

public class IndexSpec {
    public static final CompressionStrategy DEFAULT_METRIC_COMPRESSION = CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressionStrategy DEFAULT_DIMENSION_COMPRESSION = CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressionFactory.LongEncodingStrategy DEFAULT_LONG_ENCODING = CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY;
    private static final Set<CompressionStrategy> METRIC_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressionStrategy.values()));
    private static final Set<CompressionStrategy> DIMENSION_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressionStrategy.noNoneValues()));
    private static final Set<CompressionFactory.LongEncodingStrategy> LONG_ENCODING_NAMES = Sets.newHashSet(Arrays.asList(CompressionFactory.LongEncodingStrategy.values()));
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final CompressionStrategy dimensionCompression;
    private final CompressionStrategy metricCompression;
    private final CompressionFactory.LongEncodingStrategy longEncoding;

    public IndexSpec() {
        this(null, null, null, null);
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") @Nullable BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") @Nullable CompressionStrategy dimensionCompression, @JsonProperty(value="metricCompression") @Nullable CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") @Nullable CompressionFactory.LongEncodingStrategy longEncoding) {
        Preconditions.checkArgument((dimensionCompression == null || DIMENSION_COMPRESSION.contains((Object)dimensionCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{dimensionCompression});
        Preconditions.checkArgument((metricCompression == null || METRIC_COMPRESSION.contains((Object)metricCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{metricCompression});
        Preconditions.checkArgument((longEncoding == null || LONG_ENCODING_NAMES.contains((Object)longEncoding) ? 1 : 0) != 0, (String)"Unknown long encoding type[%s]", (Object[])new Object[]{longEncoding});
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : new ConciseBitmapSerdeFactory();
        this.dimensionCompression = dimensionCompression == null ? DEFAULT_DIMENSION_COMPRESSION : dimensionCompression;
        this.metricCompression = metricCompression == null ? DEFAULT_METRIC_COMPRESSION : metricCompression;
        this.longEncoding = longEncoding == null ? DEFAULT_LONG_ENCODING : longEncoding;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    public CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        return Objects.equals(this.bitmapSerdeFactory, indexSpec.bitmapSerdeFactory) && this.dimensionCompression == indexSpec.dimensionCompression && this.metricCompression == indexSpec.metricCompression && this.longEncoding == indexSpec.longEncoding;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bitmapSerdeFactory, this.dimensionCompression, this.metricCompression, this.longEncoding});
    }

    public String toString() {
        return "IndexSpec{bitmapSerdeFactory=" + this.bitmapSerdeFactory + ", dimensionCompression=" + (Object)((Object)this.dimensionCompression) + ", metricCompression=" + (Object)((Object)this.metricCompression) + ", longEncoding=" + (Object)((Object)this.longEncoding) + '}';
    }
}

