/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class EntireLayoutColumnarDoublesSerializer
implements ColumnarDoublesSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarDoublesSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeByte(x -> CompressionStrategy.NONE.getId());
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final ByteBuffer orderBuffer;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    public EntireLayoutColumnarDoublesSerializer(SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder order) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.orderBuffer = ByteBuffer.allocate(8);
        this.orderBuffer.order(order);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public void add(double value) throws IOException {
        this.orderBuffer.rewind();
        this.orderBuffer.putDouble(value);
        this.valuesOut.write(this.orderBuffer.array());
        ++this.numInserted;
    }

    @Override
    public long getSerializedSize() throws IOException {
        return (long)META_SERDE_HELPER.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        META_SERDE_HELPER.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

