/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class SpatialDimensionRowTransformer
implements Function<InputRow, InputRow> {
    private static final Joiner JOINER = Joiner.on((String)",");
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private final Map<String, SpatialDimensionSchema> spatialDimensionMap = new HashMap<String, SpatialDimensionSchema>();
    private final Set<String> spatialPartialDimNames;

    public SpatialDimensionRowTransformer(List<SpatialDimensionSchema> spatialDimensions) {
        for (SpatialDimensionSchema spatialDimension : spatialDimensions) {
            if (this.spatialDimensionMap.put(spatialDimension.getDimName(), spatialDimension) == null) continue;
            throw new ISE("Duplicate spatial dimension names found! Check your schema yo!", new Object[0]);
        }
        this.spatialPartialDimNames = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Lists.transform(spatialDimensions, (Function)new Function<SpatialDimensionSchema, List<String>>(){

            public List<String> apply(SpatialDimensionSchema input) {
                return input.getDims();
            }
        })));
    }

    public InputRow apply(final InputRow row) {
        final HashMap<String, List<String>> spatialLookup = new HashMap<String, List<String>>();
        final ArrayList finalDims = Lists.newArrayList((Iterable)Iterables.filter((Iterable)row.getDimensions(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !SpatialDimensionRowTransformer.this.spatialDimensionMap.containsKey(input) && !SpatialDimensionRowTransformer.this.spatialPartialDimNames.contains(input);
            }
        }));
        InputRow retVal = new InputRow(){

            public List<String> getDimensions() {
                return finalDims;
            }

            public long getTimestampFromEpoch() {
                return row.getTimestampFromEpoch();
            }

            public DateTime getTimestamp() {
                return row.getTimestamp();
            }

            public List<String> getDimension(String dimension) {
                List retVal = (List)spatialLookup.get(dimension);
                return retVal == null ? row.getDimension(dimension) : retVal;
            }

            public Object getRaw(String dimension) {
                List retVal = (List)spatialLookup.get(dimension);
                return retVal == null ? row.getRaw(dimension) : retVal;
            }

            public Number getMetric(String metric) {
                return row.getMetric(metric);
            }

            public String toString() {
                return row.toString();
            }

            public int compareTo(Row o) {
                return this.getTimestamp().compareTo((ReadableInstant)o.getTimestamp());
            }
        };
        for (Map.Entry<String, SpatialDimensionSchema> entry : this.spatialDimensionMap.entrySet()) {
            String spatialDimName = entry.getKey();
            SpatialDimensionSchema spatialDim = entry.getValue();
            List dimVals = row.getDimension(spatialDimName);
            if (dimVals != null && !dimVals.isEmpty()) {
                if (dimVals.size() != 1) {
                    throw new ISE("Spatial dimension value must be in an array!", new Object[0]);
                }
                if (!this.isJoinedSpatialDimValValid((String)dimVals.get(0))) continue;
                spatialLookup.put(spatialDimName, dimVals);
                finalDims.add(spatialDimName);
                continue;
            }
            ArrayList spatialDimVals = new ArrayList();
            for (String dim : spatialDim.getDims()) {
                List partialDimVals = row.getDimension(dim);
                if (!this.isSpatialDimValsValid(partialDimVals)) continue;
                spatialDimVals.addAll(partialDimVals);
            }
            if (spatialDimVals.size() != spatialDim.getDims().size()) continue;
            spatialLookup.put(spatialDimName, Collections.singletonList(JOINER.join(spatialDimVals)));
            finalDims.add(spatialDimName);
        }
        return retVal;
    }

    private boolean isSpatialDimValsValid(List<String> dimVals) {
        if (dimVals == null || dimVals.isEmpty()) {
            return false;
        }
        for (String dimVal : dimVals) {
            if (SpatialDimensionRowTransformer.tryParseFloat(dimVal) != null) continue;
            return false;
        }
        return true;
    }

    private boolean isJoinedSpatialDimValValid(String dimVal) {
        if (dimVal == null || dimVal.isEmpty()) {
            return false;
        }
        Iterable dimVals = SPLITTER.split((CharSequence)dimVal);
        for (String val : dimVals) {
            if (SpatialDimensionRowTransformer.tryParseFloat(val) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Float tryParseFloat(String val) {
        try {
            return Float.valueOf(Float.parseFloat(val));
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static float[] decode(String encodedCoordinate) {
        if (encodedCoordinate == null) {
            return null;
        }
        ImmutableList parts = ImmutableList.copyOf((Iterable)SPLITTER.split((CharSequence)encodedCoordinate));
        float[] coordinate = new float[parts.size()];
        for (int i = 0; i < coordinate.length; ++i) {
            Float floatPart = SpatialDimensionRowTransformer.tryParseFloat((String)parts.get(i));
            if (floatPart == null) {
                return null;
            }
            coordinate[i] = floatPart.floatValue();
        }
        return coordinate;
    }
}

