/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.AbstractPrioritizedCallable;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.context.ResponseContext;

public class AsyncQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final ListeningExecutorService executor;
    private final QueryWatcher queryWatcher;

    public AsyncQueryRunner(QueryRunner<T> baseRunner, ExecutorService executor, QueryWatcher queryWatcher) {
        this.baseRunner = baseRunner;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final ResponseContext responseContext) {
        final Query<T> query = queryPlus.getQuery();
        int priority = QueryContexts.getPriority(query);
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        final ListenableFuture future = this.executor.submit((Callable)new AbstractPrioritizedCallable<Sequence<T>>(priority){

            @Override
            public Sequence<T> call() {
                return AsyncQueryRunner.this.baseRunner.run(threadSafeQueryPlus, responseContext);
            }
        });
        this.queryWatcher.registerQuery(query, future);
        return new LazySequence(new Supplier<Sequence<T>>(){

            public Sequence<T> get() {
                try {
                    if (QueryContexts.hasTimeout(query)) {
                        return (Sequence)future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
                    }
                    return (Sequence)future.get();
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }
}

