/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.druid.query.aggregation.HistogramVisual;

public class Histogram {
    public float[] breaks;
    public long[] bins;
    public transient long count;
    public float min;
    public float max;

    public Histogram(float[] breaks) {
        Preconditions.checkArgument((breaks != null ? 1 : 0) != 0, (Object)"Histogram breaks must not be null");
        this.breaks = breaks;
        this.bins = new long[this.breaks.length + 1];
        this.count = 0L;
        this.min = Float.POSITIVE_INFINITY;
        this.max = Float.NEGATIVE_INFINITY;
    }

    public Histogram(float[] breaks, long[] bins, float min, float max) {
        this.breaks = breaks;
        this.bins = bins;
        this.min = min;
        this.max = max;
        for (long k : bins) {
            this.count += k;
        }
    }

    public Histogram(Histogram other) {
        this.breaks = other.breaks;
        this.bins = (long[])other.bins.clone();
        this.min = other.min;
        this.max = other.max;
        this.count = other.count;
    }

    public void copyFrom(Histogram other) {
        this.breaks = other.breaks;
        if (this.bins.length == other.bins.length) {
            System.arraycopy(other.bins, 0, this.bins, 0, this.bins.length);
        } else {
            this.bins = (long[])other.bins.clone();
        }
        this.min = other.min;
        this.max = other.max;
        this.count = other.count;
    }

    public void offer(float d) {
        int index;
        int pos;
        if (d > this.max) {
            this.max = d;
        }
        if (d < this.min) {
            this.min = d;
        }
        int n = pos = (index = Arrays.binarySearch(this.breaks, d)) >= 0 ? index : -(index + 1);
        this.bins[n] = this.bins[n] + 1L;
        ++this.count;
    }

    public Histogram fold(Histogram h) {
        Preconditions.checkArgument((boolean)Arrays.equals(this.breaks, h.breaks), (Object)"Cannot fold histograms with different breaks");
        if (h.min < this.min) {
            this.min = h.min;
        }
        if (h.max > this.max) {
            this.max = h.max;
        }
        this.count += h.count;
        for (int i = 0; i < this.bins.length; ++i) {
            int n = i;
            this.bins[n] = this.bins[n] + h.bins[i];
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Histogram histogram = (Histogram)o;
        if (this.count != histogram.count) {
            return false;
        }
        if (Float.compare(histogram.max, this.max) != 0) {
            return false;
        }
        if (Float.compare(histogram.min, this.min) != 0) {
            return false;
        }
        if (!Arrays.equals(this.bins, histogram.bins)) {
            return false;
        }
        return Arrays.equals(this.breaks, histogram.breaks);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.breaks);
        result = 31 * result + Arrays.hashCode(this.bins);
        result = 31 * result + (this.min != 0.0f ? Float.floatToIntBits(this.min) : 0);
        result = 31 * result + (this.max != 0.0f ? Float.floatToIntBits(this.max) : 0);
        return result;
    }

    @JsonValue
    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(4 + 4 * this.breaks.length + 8 * this.bins.length + 8);
        buf.putInt(this.breaks.length);
        for (float b : this.breaks) {
            buf.putFloat(b);
        }
        for (long c : this.bins) {
            buf.putLong(c);
        }
        buf.putFloat(this.min);
        buf.putFloat(this.max);
        return buf.array();
    }

    public HistogramVisual asVisual() {
        float[] visualCounts = new float[this.bins.length - 2];
        for (int i = 0; i < visualCounts.length; ++i) {
            visualCounts[i] = this.bins[i + 1];
        }
        return new HistogramVisual(this.breaks, visualCounts, new float[]{this.min, this.max});
    }

    public static Histogram fromBytes(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return Histogram.fromBytes(buf);
    }

    public static Histogram fromBytes(ByteBuffer buf) {
        int i;
        int n = buf.getInt();
        float[] breaks = new float[n];
        long[] bins = new long[n + 1];
        for (i = 0; i < breaks.length; ++i) {
            breaks[i] = buf.getFloat();
        }
        for (i = 0; i < bins.length; ++i) {
            bins[i] = buf.getLong();
        }
        float min = buf.getFloat();
        float max = buf.getFloat();
        return new Histogram(breaks, bins, min, max);
    }

    public String toString() {
        return "Histogram{bins=" + Arrays.toString(this.bins) + ", count=" + this.count + ", breaks=" + Arrays.toString(this.breaks) + '}';
    }
}

