/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.druid.query.groupby.epinephelinae.TemporaryStorageFullException;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.segment.ColumnSelectorFactory;

public class SpillingGrouper<KeyType>
implements Grouper<KeyType> {
    private static final Logger log = new Logger(SpillingGrouper.class);
    private static final AggregateResult DISK_FULL = AggregateResult.partial(0, "Not enough disk space to execute this query. Try raising druid.query.groupBy.maxOnDiskStorage.");
    private final Grouper<KeyType> grouper;
    private final Grouper.KeySerde<KeyType> keySerde;
    private final LimitedTemporaryStorage temporaryStorage;
    private final ObjectMapper spillMapper;
    private final AggregatorFactory[] aggregatorFactories;
    private final Comparator<Grouper.Entry<KeyType>> keyObjComparator;
    private final Comparator<Grouper.Entry<KeyType>> defaultOrderKeyObjComparator;
    private final List<File> files = new ArrayList<File>();
    private final List<File> dictionaryFiles = new ArrayList<File>();
    private final boolean sortHasNonGroupingFields;
    private boolean spillingAllowed;

    public SpillingGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerdeFactory<KeyType> keySerdeFactory, ColumnSelectorFactory columnSelectorFactory, AggregatorFactory[] aggregatorFactories, int bufferGrouperMaxSize, float bufferGrouperMaxLoadFactor, int bufferGrouperInitialBuckets, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, boolean spillingAllowed, DefaultLimitSpec limitSpec, boolean sortHasNonGroupingFields, int mergeBufferSize) {
        this.keySerde = keySerdeFactory.factorize();
        this.keyObjComparator = keySerdeFactory.objectComparator(false);
        this.defaultOrderKeyObjComparator = keySerdeFactory.objectComparator(true);
        if (limitSpec != null) {
            LimitedBufferHashGrouper<KeyType> limitGrouper = new LimitedBufferHashGrouper<KeyType>(bufferSupplier, this.keySerde, AggregatorAdapters.factorizeBuffered(columnSelectorFactory, Arrays.asList(aggregatorFactories)), bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets, limitSpec.getLimit(), sortHasNonGroupingFields);
            if (!limitGrouper.validateBufferCapacity(mergeBufferSize)) {
                if (sortHasNonGroupingFields) {
                    log.debug("Ignoring forceLimitPushDown, insufficient buffer capacity.", new Object[0]);
                }
                this.grouper = new BufferHashGrouper<KeyType>(bufferSupplier, this.keySerde, AggregatorAdapters.factorizeBuffered(columnSelectorFactory, Arrays.asList(aggregatorFactories)), bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets, sortHasNonGroupingFields);
            } else {
                this.grouper = limitGrouper;
            }
        } else {
            this.grouper = new BufferHashGrouper<KeyType>(bufferSupplier, this.keySerde, AggregatorAdapters.factorizeBuffered(columnSelectorFactory, Arrays.asList(aggregatorFactories)), bufferGrouperMaxSize, bufferGrouperMaxLoadFactor, bufferGrouperInitialBuckets, true);
        }
        this.aggregatorFactories = aggregatorFactories;
        this.temporaryStorage = temporaryStorage;
        this.spillMapper = spillMapper;
        this.spillingAllowed = spillingAllowed;
        this.sortHasNonGroupingFields = sortHasNonGroupingFields;
    }

    @Override
    public void init() {
        this.grouper.init();
    }

    @Override
    public boolean isInitialized() {
        return this.grouper.isInitialized();
    }

    @Override
    public AggregateResult aggregate(KeyType key, int keyHash) {
        AggregateResult result = this.grouper.aggregate(key, keyHash);
        if (result.isOk() || !this.spillingAllowed || this.temporaryStorage.maxSize() <= 0L) {
            return result;
        }
        assert (result.getCount() == 0);
        try {
            this.spill();
        }
        catch (TemporaryStorageFullException e) {
            return DISK_FULL;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.grouper.aggregate(key, keyHash);
    }

    @Override
    public void reset() {
        this.grouper.reset();
        this.deleteFiles();
    }

    @Override
    public void close() {
        this.grouper.close();
        this.deleteFiles();
    }

    public List<String> mergeAndGetDictionary() {
        HashSet<Object> mergedDictionary = new HashSet<Object>();
        mergedDictionary.addAll(this.keySerde.getDictionary());
        for (File dictFile : this.dictionaryFiles) {
            try {
                InputStream fileStream = Files.newInputStream(dictFile.toPath(), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    LZ4BlockInputStream blockStream = new LZ4BlockInputStream(fileStream);
                    Throwable throwable2 = null;
                    try {
                        MappingIterator dictIterator = this.spillMapper.readValues(this.spillMapper.getFactory().createParser((InputStream)blockStream), this.spillMapper.getTypeFactory().constructType(String.class));
                        Throwable throwable3 = null;
                        try {
                            while (dictIterator.hasNext()) {
                                mergedDictionary.add(dictIterator.next());
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (dictIterator == null) continue;
                            if (throwable3 != null) {
                                try {
                                    dictIterator.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            dictIterator.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (blockStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                blockStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        blockStream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (fileStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    fileStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new ArrayList<String>(mergedDictionary);
    }

    public void setSpillingAllowed(boolean spillingAllowed) {
        this.spillingAllowed = spillingAllowed;
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        ArrayList<Object> iterators = new ArrayList<Object>(1 + this.files.size());
        iterators.add(this.grouper.iterator(sorted));
        Closer closer = Closer.create();
        for (File file : this.files) {
            MappingIterator<Grouper.Entry<KeyType>> fileIterator = this.read(file, this.keySerde.keyClazz());
            iterators.add(CloseableIterators.withEmptyBaggage((Iterator)Iterators.transform(fileIterator, (Function)new Function<Grouper.Entry<KeyType>, Grouper.Entry<KeyType>>(){

                public Grouper.Entry<KeyType> apply(Grouper.Entry<KeyType> entry) {
                    Object[] deserializedValues = new Object[entry.getValues().length];
                    for (int i = 0; i < deserializedValues.length; ++i) {
                        deserializedValues[i] = SpillingGrouper.this.aggregatorFactories[i].deserialize(entry.getValues()[i]);
                        if (!(deserializedValues[i] instanceof Integer)) continue;
                        deserializedValues[i] = ((Integer)deserializedValues[i]).longValue();
                    }
                    return new Grouper.Entry(entry.getKey(), deserializedValues);
                }
            })));
            closer.register(fileIterator);
        }
        CloseableIterator baseIterator = this.sortHasNonGroupingFields ? CloseableIterators.mergeSorted(iterators, this.defaultOrderKeyObjComparator) : (sorted ? CloseableIterators.mergeSorted(iterators, this.keyObjComparator) : CloseableIterators.concat(iterators));
        return CloseableIterators.wrap((Iterator)baseIterator, (Closeable)closer);
    }

    private void spill() throws IOException {
        try (CloseableIterator<Grouper.Entry<KeyType>> iterator = this.grouper.iterator(true);){
            this.files.add(this.spill((Iterator)iterator));
            this.dictionaryFiles.add(this.spill(this.keySerde.getDictionary().iterator()));
            this.grouper.reset();
        }
    }

    /*
     * Exception decompiling
     */
    private <T> File spill(Iterator<T> iterator) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MappingIterator<Grouper.Entry<KeyType>> read(File file, Class<KeyType> keyClazz) {
        try {
            return this.spillMapper.readValues(this.spillMapper.getFactory().createParser((InputStream)new LZ4BlockInputStream((InputStream)new FileInputStream(file))), this.spillMapper.getTypeFactory().constructParametricType(Grouper.Entry.class, new Class[]{keyClazz}));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteFiles() {
        for (File file : this.files) {
            this.temporaryStorage.delete(file);
        }
        this.files.clear();
    }
}

