/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class DoubleColumnSerializer
implements GenericColumnSerializer<Object> {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressionStrategy compression;
    private ColumnarDoublesSerializer writer;

    public static DoubleColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compression) {
        return new DoubleColumnSerializer(segmentWriteOutMedium, filenameBase, IndexIO.BYTE_ORDER, compression);
    }

    private DoubleColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getDoubleSerializer(this.segmentWriteOutMedium, StringUtils.format((String)"%s.double_column", (Object[])new Object[]{this.filenameBase}), this.byteOrder, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(ColumnValueSelector<?> selector) throws IOException {
        this.writer.add(selector.getDouble());
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeTo(channel, smoosher);
    }
}

