/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.serde.Serializer;

public class ComplexColumnPartSerde
implements ColumnPartSerde {
    private final String typeName;
    @Nullable
    private final ComplexMetricSerde serde;
    private final Serializer serializer;

    private ComplexColumnPartSerde(String typeName, Serializer serializer) {
        this.typeName = typeName;
        this.serde = ComplexMetrics.getSerdeForType(typeName);
        this.serializer = serializer;
    }

    @JsonCreator
    public static ComplexColumnPartSerde createDeserializer(@JsonProperty(value="typeName") String complexType) {
        return new ComplexColumnPartSerde(complexType, null);
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @JsonProperty
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig) -> {
            if (this.serde != null) {
                this.serde.deserializeColumn(buffer, builder);
            }
        };
    }

    public static class SerializerBuilder {
        @Nullable
        private String typeName = null;
        @Nullable
        private GenericColumnSerializer delegate = null;

        public SerializerBuilder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public SerializerBuilder withDelegate(GenericColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public ComplexColumnPartSerde build() {
            return new ComplexColumnPartSerde(this.typeName, this.delegate);
        }
    }
}

