/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;

public class SubqueryQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;

    public SubqueryQueryRunner(QueryRunner<T> baseRunner) {
        this.baseRunner = baseRunner;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        DataSource dataSource = queryPlus.getQuery().getDataSource();
        boolean forcePushDownNestedQuery = queryPlus.getQuery().getContextBoolean("forcePushDownNestedQuery", false);
        if (dataSource instanceof QueryDataSource && !forcePushDownNestedQuery) {
            return this.run(queryPlus.withQuery(((QueryDataSource)dataSource).getQuery()), responseContext);
        }
        QueryPlus<T> newQuery = queryPlus;
        if (forcePushDownNestedQuery) {
            newQuery = queryPlus.withQuery(queryPlus.getQuery().withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"forcePushDownNestedQuery", (Object)false, (Object)"executingNestedQuery", (Object)true)));
        }
        return this.baseRunner.run(newQuery, responseContext);
    }
}

