/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.QueryConfig;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferKeySerde;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.GroupByQueryEngineV2;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.VectorGrouper;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnStrategizer;
import org.apache.druid.query.vector.VectorCursorGranularizer;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class VectorGroupByEngine {
    private VectorGroupByEngine() {
    }

    public static boolean canVectorize(GroupByQuery query, StorageAdapter adapter, @Nullable Filter filter) {
        return GroupByQueryEngineV2.isAllSingleValueDims(adapter::getColumnCapabilities, query.getDimensions()) && query.getDimensions().stream().allMatch(DimensionSpec::canVectorize) && query.getAggregatorSpecs().stream().allMatch(AggregatorFactory::canVectorize) && adapter.canVectorize(filter, query.getVirtualColumns(), false);
    }

    public static Sequence<ResultRow> process(final GroupByQuery query, final StorageAdapter storageAdapter, final ByteBuffer processingBuffer, final @Nullable DateTime fudgeTimestamp, @Nullable Filter filter, final Interval interval, final GroupByQueryConfig config, final QueryConfig queryConfig) {
        if (!VectorGroupByEngine.canVectorize(query, storageAdapter, filter)) {
            throw new ISE("Cannot vectorize", new Object[0]);
        }
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ResultRow, CloseableIterator<ResultRow>>(){

            public CloseableIterator<ResultRow> make() {
                VectorCursor cursor = storageAdapter.makeVectorCursor(Filters.toFilter(query.getDimFilter()), interval, query.getVirtualColumns(), false, queryConfig.getVectorSize(), null);
                if (cursor == null) {
                    return new CloseableIterator<ResultRow>(){

                        public boolean hasNext() {
                            return false;
                        }

                        public ResultRow next() {
                            throw new NoSuchElementException();
                        }

                        public void close() {
                        }
                    };
                }
                try {
                    VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
                    List<GroupByVectorColumnSelector> dimensions = query.getDimensions().stream().map(dimensionSpec -> DimensionHandlerUtils.makeVectorProcessor(dimensionSpec, GroupByVectorColumnStrategizer.instance(), columnSelectorFactory)).collect(Collectors.toList());
                    return new VectorGroupByEngineIterator(query, config, storageAdapter, cursor, interval, dimensions, processingBuffer, fudgeTimestamp);
                }
                catch (Throwable e) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable e2) {
                        e.addSuppressed(e2);
                    }
                    throw e;
                }
            }

            public void cleanup(CloseableIterator<ResultRow> iterFromMake) {
                try {
                    iterFromMake.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static class VectorGroupByEngineIterator
    implements CloseableIterator<ResultRow> {
        private final GroupByQuery query;
        private final GroupByQueryConfig querySpecificConfig;
        private final StorageAdapter storageAdapter;
        private final VectorCursor cursor;
        private final List<GroupByVectorColumnSelector> selectors;
        private final ByteBuffer processingBuffer;
        private final DateTime fudgeTimestamp;
        private final int keySize;
        private final int[] keySpace;
        private final Grouper.KeySerde<ByteBuffer> keySerde;
        private final VectorGrouper vectorGrouper;
        @Nullable
        private final VectorCursorGranularizer granulizer;
        private final Iterator<Interval> bucketIterator;
        @Nullable
        private Interval bucketInterval;
        private int partiallyAggregatedRows = -1;
        @Nullable
        private CloseableGrouperIterator<ByteBuffer, ResultRow> delegate = null;

        VectorGroupByEngineIterator(GroupByQuery query, GroupByQueryConfig config, StorageAdapter storageAdapter, VectorCursor cursor, Interval queryInterval, List<GroupByVectorColumnSelector> selectors, ByteBuffer processingBuffer, @Nullable DateTime fudgeTimestamp) {
            this.query = query;
            this.querySpecificConfig = config;
            this.storageAdapter = storageAdapter;
            this.cursor = cursor;
            this.selectors = selectors;
            this.processingBuffer = processingBuffer;
            this.fudgeTimestamp = fudgeTimestamp;
            this.keySize = selectors.stream().mapToInt(GroupByVectorColumnSelector::getGroupingKeySize).sum();
            this.keySpace = new int[this.keySize * cursor.getMaxVectorSize()];
            this.keySerde = new ByteBufferKeySerde(this.keySize * 4);
            this.vectorGrouper = this.makeGrouper();
            this.granulizer = VectorCursorGranularizer.create(storageAdapter, cursor, query.getGranularity(), queryInterval);
            this.bucketIterator = this.granulizer != null ? this.granulizer.getBucketIterable().iterator() : Collections.emptyIterator();
            this.bucketInterval = this.bucketIterator.hasNext() ? this.bucketIterator.next() : null;
        }

        public ResultRow next() {
            if (this.delegate == null || !this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        public boolean hasNext() {
            boolean moreToRead;
            if (this.delegate != null && this.delegate.hasNext()) {
                return true;
            }
            boolean bl = moreToRead = !this.cursor.isDone() || this.partiallyAggregatedRows >= 0;
            if (this.bucketInterval != null && moreToRead) {
                while (this.delegate == null || !this.delegate.hasNext()) {
                    if (this.delegate != null) {
                        this.delegate.close();
                        this.vectorGrouper.reset();
                    }
                    this.delegate = this.initNewDelegate();
                }
                return true;
            }
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.cursor.close();
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        private VectorGrouper makeGrouper() {
            int cardinalityForArrayAggregation = GroupByQueryEngineV2.getCardinalityForArrayAggregation(this.querySpecificConfig, this.query, this.storageAdapter, this.processingBuffer);
            VectorGrouper grouper = cardinalityForArrayAggregation >= 0 ? new BufferArrayGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.processingBuffer), AggregatorAdapters.factorizeVector(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), cardinalityForArrayAggregation) : new BufferHashGrouper<ByteBuffer>((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.processingBuffer), this.keySerde, AggregatorAdapters.factorizeVector(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets(), true);
            grouper.initVectorized(this.cursor.getMaxVectorSize());
            return grouper;
        }

        private CloseableGrouperIterator<ByteBuffer, ResultRow> initNewDelegate() {
            DateTime timestamp;
            assert (this.bucketInterval != null);
            DateTime dateTime = timestamp = this.fudgeTimestamp != null ? this.fudgeTimestamp : this.query.getGranularity().toDateTime(this.bucketInterval.getStartMillis());
            while (!this.cursor.isDone()) {
                int startOffset;
                if (this.partiallyAggregatedRows < 0) {
                    this.granulizer.setCurrentOffsets(this.bucketInterval);
                    startOffset = this.granulizer.getStartOffset();
                } else {
                    startOffset = this.granulizer.getStartOffset() + this.partiallyAggregatedRows;
                }
                if (this.granulizer.getEndOffset() > startOffset) {
                    int keyOffset = 0;
                    for (GroupByVectorColumnSelector selector : this.selectors) {
                        selector.writeKeys(this.keySpace, this.keySize, keyOffset, startOffset, this.granulizer.getEndOffset());
                        keyOffset += selector.getGroupingKeySize();
                    }
                    AggregateResult result = this.vectorGrouper.aggregateVector(this.keySpace, startOffset, this.granulizer.getEndOffset());
                    this.partiallyAggregatedRows = result.isOk() ? -1 : (this.partiallyAggregatedRows < 0 ? result.getCount() : (this.partiallyAggregatedRows += result.getCount()));
                } else {
                    this.partiallyAggregatedRows = -1;
                }
                if (this.partiallyAggregatedRows >= 0) break;
                if (this.granulizer.advanceCursorWithinBucket()) continue;
                this.bucketInterval = this.bucketIterator.hasNext() ? this.bucketIterator.next() : null;
                break;
            }
            boolean resultRowHasTimestamp = this.query.getResultRowHasTimestamp();
            int resultRowDimensionStart = this.query.getResultRowDimensionStart();
            int resultRowAggregatorStart = this.query.getResultRowAggregatorStart();
            return new CloseableGrouperIterator<ByteBuffer, ResultRow>(this.vectorGrouper.iterator(), entry -> {
                int i;
                ResultRow resultRow = ResultRow.create(this.query.getResultRowSizeWithoutPostAggregators());
                if (resultRowHasTimestamp) {
                    resultRow.set(0, timestamp.getMillis());
                }
                int keyOffset = 0;
                for (i = 0; i < this.selectors.size(); ++i) {
                    GroupByVectorColumnSelector selector = this.selectors.get(i);
                    selector.writeKeyToResultRow((ByteBuffer)entry.getKey(), keyOffset, resultRow, resultRowDimensionStart + i);
                    keyOffset += selector.getGroupingKeySize();
                }
                GroupByQueryEngineV2.convertRowTypesToOutputTypes(this.query.getDimensions(), resultRow, resultRowDimensionStart);
                for (i = 0; i < entry.getValues().length; ++i) {
                    resultRow.set(resultRowAggregatorStart + i, entry.getValues()[i]);
                }
                return resultRow;
            }, this.vectorGrouper);
        }
    }
}

