/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.WrappedBitSetBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableBitSetBitmap;

public class BitSetBitmapFactory
implements BitmapFactory {
    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedBitSetBitmap();
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return this.makeEmptyMutableBitmap();
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        return mutableBitmap;
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedBitSetBitmap(BitSet.valueOf(b.array()));
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) {
        WrappedImmutableBitSetBitmap newSet = null;
        for (ImmutableBitmap bm : b) {
            if (null == newSet) {
                newSet = new WrappedBitSetBitmap(((WrappedBitSetBitmap)bm).cloneBitSet());
                continue;
            }
            newSet.union(bm);
        }
        return newSet;
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) {
        WrappedImmutableBitSetBitmap newSet = null;
        for (ImmutableBitmap bm : b) {
            if (null == newSet) {
                newSet = new WrappedBitSetBitmap(((WrappedBitSetBitmap)bm).cloneBitSet());
                continue;
            }
            newSet.intersection(bm);
        }
        return newSet;
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return null;
    }
}

