/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;

@JsonTypeName(value="table")
public class TableDataSource
implements DataSource {
    private final String name;

    @JsonCreator
    public TableDataSource(@JsonProperty(value="name") String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"'name' must be nonnull");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.singleton(this.name);
    }

    @Override
    public List<DataSource> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (!children.isEmpty()) {
            throw new IAE("Cannot accept children", new Object[0]);
        }
        return this;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableDataSource)) {
            return false;
        }
        TableDataSource that = (TableDataSource)o;
        return this.name.equals(that.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }
}

