/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.utils.CollectionUtils;

public class ExpressionPostAggregator
implements PostAggregator {
    private static final Comparator<Comparable> DEFAULT_COMPARATOR = Comparator.nullsFirst((o1, o2) -> {
        if (o1 instanceof Long && o2 instanceof Long) {
            return Long.compare((Long)o1, (Long)o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return Double.compare(((Number)((Object)o1)).doubleValue(), ((Number)((Object)o2)).doubleValue());
        }
        return o1.compareTo(o2);
    });
    private final String name;
    private final String expression;
    private final Comparator<Comparable> comparator;
    private final String ordering;
    private final ExprMacroTable macroTable;
    private final Map<String, Function<Object, Object>> finalizers;
    private final Supplier<Expr> parsed;
    private final Supplier<Set<String>> dependentFields;

    @JsonCreator
    public ExpressionPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression, @JsonProperty(value="ordering") @Nullable String ordering, @JacksonInject ExprMacroTable macroTable) {
        this(name, expression, ordering, macroTable, (Map<String, Function<Object, Object>>)ImmutableMap.of());
    }

    private ExpressionPostAggregator(String name, String expression, @Nullable String ordering, ExprMacroTable macroTable, Map<String, Function<Object, Object>> finalizers) {
        this(name, expression, ordering, macroTable, finalizers, (Supplier<Expr>)Suppliers.memoize(() -> Parser.parse((String)expression, (ExprMacroTable)macroTable)));
    }

    private ExpressionPostAggregator(String name, String expression, @Nullable String ordering, ExprMacroTable macroTable, Map<String, Function<Object, Object>> finalizers, Supplier<Expr> parsed) {
        this(name, expression, ordering, macroTable, finalizers, parsed, (Supplier<Set<String>>)Suppliers.memoize(() -> ((Expr)parsed.get()).analyzeInputs().getRequiredBindings()));
    }

    private ExpressionPostAggregator(String name, String expression, @Nullable String ordering, ExprMacroTable macroTable, Map<String, Function<Object, Object>> finalizers, Supplier<Expr> parsed, Supplier<Set<String>> dependentFields) {
        Preconditions.checkArgument((expression != null ? 1 : 0) != 0, (Object)"expression cannot be null");
        this.name = name;
        this.expression = expression;
        this.ordering = ordering;
        this.comparator = ordering == null ? DEFAULT_COMPARATOR : Ordering.valueOf(ordering);
        this.macroTable = macroTable;
        this.finalizers = finalizers;
        this.parsed = parsed;
        this.dependentFields = dependentFields;
    }

    @Override
    public Set<String> getDependentFields() {
        return (Set)this.dependentFields.get();
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Map finalizedValues = Maps.transformEntries(values, (k, v) -> {
            Function<Object, Object> finalizer = this.finalizers.get(k);
            return finalizer != null ? finalizer.apply(v) : v;
        });
        return ((Expr)this.parsed.get()).eval(Parser.withMap((Map)finalizedValues)).value();
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ExpressionPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return new ExpressionPostAggregator(this.name, this.expression, this.ordering, this.macroTable, CollectionUtils.mapValues(aggregators, aggregatorFactory -> obj -> aggregatorFactory.finalizeComputation(obj)), this.parsed, this.dependentFields);
    }

    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="ordering")
    public String getOrdering() {
        return this.ordering;
    }

    public String toString() {
        return "ExpressionPostAggregator{name='" + this.name + '\'' + ", expression='" + this.expression + '\'' + ", ordering=" + this.ordering + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(4).appendString(this.expression).appendString(this.ordering).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionPostAggregator that = (ExpressionPostAggregator)o;
        if (!this.comparator.equals(that.comparator)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.expression, that.expression)) {
            return false;
        }
        return Objects.equals(this.ordering, that.ordering);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.comparator.hashCode();
        result = 31 * result + (this.ordering != null ? this.ordering.hashCode() : 0);
        return result;
    }

    public static enum Ordering implements Comparator<Comparable>
    {
        numericFirst{

            @Override
            public int compare(Comparable lhs, Comparable rhs) {
                if (lhs instanceof Long && rhs instanceof Long) {
                    return Long.compare(((Number)((Object)lhs)).longValue(), ((Number)((Object)rhs)).longValue());
                }
                if (lhs instanceof Number && rhs instanceof Number) {
                    double d1 = ((Number)((Object)lhs)).doubleValue();
                    double d2 = ((Number)((Object)rhs)).doubleValue();
                    if (Double.isFinite(d1) && !Double.isFinite(d2)) {
                        return 1;
                    }
                    if (!Double.isFinite(d1) && Double.isFinite(d2)) {
                        return -1;
                    }
                    return Double.compare(d1, d2);
                }
                return Comparators.naturalNullsFirst().compare((Object)lhs, (Object)rhs);
            }
        };

    }
}

