/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.BaseFilteredDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ForwardingFilteredDimensionSelector;
import org.apache.druid.query.dimension.PredicateFilteredDimensionSelector;
import org.apache.druid.segment.DimensionSelector;

public class PrefixFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 4;
    private final String prefix;

    public PrefixFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="prefix") String prefix) {
        super(delegate);
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix must not be null");
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return null;
        }
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    String val = NullHandling.nullToEmptyIfNeeded((String)input);
                    return val == null ? false : val.startsWith(PrefixFilteredDimensionSpec.this.prefix);
                }
            });
        }
        int count = 0;
        Int2IntOpenHashMap forwardMapping = new Int2IntOpenHashMap();
        forwardMapping.defaultReturnValue(-1);
        for (int i = 0; i < selectorCardinality; ++i) {
            String val = NullHandling.nullToEmptyIfNeeded((String)selector.lookupName(i));
            if (val == null || !val.startsWith(this.prefix)) continue;
            forwardMapping.put(i, count++);
        }
        int[] reverseMapping = new int[forwardMapping.size()];
        for (Int2IntMap.Entry e : forwardMapping.int2IntEntrySet()) {
            reverseMapping[e.getIntValue()] = e.getIntKey();
        }
        return new ForwardingFilteredDimensionSelector(selector, forwardMapping, reverseMapping);
    }

    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[] prefixBytes = StringUtils.toUtf8((String)this.prefix);
        return ByteBuffer.allocate(2 + delegateCacheKey.length + prefixBytes.length).put((byte)4).put(delegateCacheKey).put((byte)-1).put(prefixBytes).array();
    }

    @Override
    public DimensionSpec withDimension(String newDimension) {
        return new PrefixFilteredDimensionSpec(this.delegate.withDimension(newDimension), this.prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefixFilteredDimensionSpec that = (PrefixFilteredDimensionSpec)o;
        if (!this.delegate.equals(that.delegate)) {
            return false;
        }
        return this.prefix.equals(that.prefix);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + this.prefix.hashCode();
        return result;
    }

    public String toString() {
        return "PrefixFilteredDimensionSpec{Prefix='" + this.prefix + '\'' + '}';
    }
}

