/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.QuerySegmentSpec;

public class DataSourceAnalysis {
    private final DataSource dataSource;
    private final DataSource baseDataSource;
    @Nullable
    private final QuerySegmentSpec baseQuerySegmentSpec;
    private final List<PreJoinableClause> preJoinableClauses;

    private DataSourceAnalysis(DataSource dataSource, DataSource baseDataSource, @Nullable QuerySegmentSpec baseQuerySegmentSpec, List<PreJoinableClause> preJoinableClauses) {
        if (baseDataSource instanceof JoinDataSource) {
            throw new IAE("Base dataSource cannot be a join! Original dataSource was: %s", new Object[]{dataSource});
        }
        this.dataSource = dataSource;
        this.baseDataSource = baseDataSource;
        this.baseQuerySegmentSpec = baseQuerySegmentSpec;
        this.preJoinableClauses = preJoinableClauses;
    }

    public static DataSourceAnalysis forDataSource(DataSource dataSource) {
        QuerySegmentSpec baseQuerySegmentSpec = null;
        DataSource current = dataSource;
        while (current instanceof QueryDataSource) {
            Query subQuery = ((QueryDataSource)current).getQuery();
            if (!(subQuery instanceof BaseQuery)) {
                throw new IAE("Cannot analyze subquery of class[%s]", new Object[]{subQuery.getClass().getName()});
            }
            baseQuerySegmentSpec = ((BaseQuery)subQuery).getQuerySegmentSpec();
            current = subQuery.getDataSource();
        }
        if (current instanceof JoinDataSource) {
            Pair<DataSource, List<PreJoinableClause>> flattened = DataSourceAnalysis.flattenJoin((JoinDataSource)current);
            return new DataSourceAnalysis(dataSource, (DataSource)flattened.lhs, baseQuerySegmentSpec, (List)flattened.rhs);
        }
        return new DataSourceAnalysis(dataSource, current, baseQuerySegmentSpec, Collections.emptyList());
    }

    private static Pair<DataSource, List<PreJoinableClause>> flattenJoin(JoinDataSource dataSource) {
        DataSource current = dataSource;
        ArrayList<PreJoinableClause> preJoinableClauses = new ArrayList<PreJoinableClause>();
        while (current instanceof JoinDataSource) {
            JoinDataSource joinDataSource = current;
            current = joinDataSource.getLeft();
            preJoinableClauses.add(new PreJoinableClause(joinDataSource.getRightPrefix(), joinDataSource.getRight(), joinDataSource.getJoinType(), joinDataSource.getConditionAnalysis()));
        }
        Collections.reverse(preJoinableClauses);
        return Pair.of((Object)current, preJoinableClauses);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getBaseDataSource() {
        return this.baseDataSource;
    }

    public Optional<TableDataSource> getBaseTableDataSource() {
        if (this.baseDataSource instanceof TableDataSource) {
            return Optional.of((TableDataSource)this.baseDataSource);
        }
        return Optional.empty();
    }

    public Optional<QuerySegmentSpec> getBaseQuerySegmentSpec() {
        return Optional.ofNullable(this.baseQuerySegmentSpec);
    }

    public List<PreJoinableClause> getPreJoinableClauses() {
        return this.preJoinableClauses;
    }

    public boolean isGlobal() {
        return this.dataSource.isGlobal();
    }

    public boolean isConcreteBased() {
        return this.baseDataSource.isConcrete() && this.preJoinableClauses.stream().allMatch(clause -> clause.getDataSource().isGlobal());
    }

    public boolean isConcreteTableBased() {
        return this.isConcreteBased() && (this.baseDataSource instanceof TableDataSource || this.baseDataSource instanceof UnionDataSource && this.baseDataSource.getChildren().stream().allMatch(ds -> ds instanceof TableDataSource));
    }

    public boolean isQuery() {
        return this.dataSource instanceof QueryDataSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceAnalysis that = (DataSourceAnalysis)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.baseDataSource, that.baseDataSource) && Objects.equals(this.baseQuerySegmentSpec, that.baseQuerySegmentSpec) && Objects.equals(this.preJoinableClauses, that.preJoinableClauses);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.baseDataSource, this.baseQuerySegmentSpec, this.preJoinableClauses);
    }

    public String toString() {
        return "DataSourceAnalysis{dataSource=" + this.dataSource + ", baseDataSource=" + this.baseDataSource + ", baseQuerySegmentSpec=" + this.baseQuerySegmentSpec + ", joinClauses=" + this.preJoinableClauses + '}';
    }
}

