/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;

public class Metadata {
    private final Map<String, Object> container;
    @Nullable
    private final AggregatorFactory[] aggregators;
    @Nullable
    private final TimestampSpec timestampSpec;
    @Nullable
    private final Granularity queryGranularity;
    @Nullable
    private final Boolean rollup;

    public Metadata(@JsonProperty(value="container") @Nullable Map<String, Object> container, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="timestampSpec") @Nullable TimestampSpec timestampSpec, @JsonProperty(value="queryGranularity") @Nullable Granularity queryGranularity, @JsonProperty(value="rollup") @Nullable Boolean rollup) {
        this.container = container == null ? new ConcurrentHashMap() : container;
        this.aggregators = aggregators;
        this.timestampSpec = timestampSpec;
        this.queryGranularity = queryGranularity;
        this.rollup = rollup;
    }

    @JsonProperty
    public Map<String, Object> getContainer() {
        return this.container;
    }

    @JsonProperty
    @Nullable
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    @Nullable
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    @JsonProperty
    @Nullable
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    @Nullable
    public Boolean isRollup() {
        return this.rollup;
    }

    public Metadata putAll(@Nullable Map<String, Object> other) {
        if (other != null) {
            this.container.putAll(other);
        }
        return this;
    }

    public Object get(String key) {
        return this.container.get(key);
    }

    public Metadata put(String key, @Nullable Object value) {
        if (value != null) {
            this.container.put(key, value);
        }
        return this;
    }

    @Nullable
    public static Metadata merge(@Nullable List<Metadata> toBeMerged, @Nullable AggregatorFactory[] overrideMergedAggregators) {
        if (toBeMerged == null || toBeMerged.size() == 0) {
            return null;
        }
        boolean foundSomeMetadata = false;
        HashMap<String, Object> mergedContainer = new HashMap<String, Object>();
        ArrayList<AggregatorFactory[]> aggregatorsToMerge = overrideMergedAggregators == null ? new ArrayList<AggregatorFactory[]>() : null;
        ArrayList<TimestampSpec> timestampSpecsToMerge = new ArrayList<TimestampSpec>();
        ArrayList<Granularity> gransToMerge = new ArrayList<Granularity>();
        ArrayList<Boolean> rollupToMerge = new ArrayList<Boolean>();
        for (Metadata metadata : toBeMerged) {
            if (metadata != null) {
                foundSomeMetadata = true;
                if (aggregatorsToMerge != null) {
                    aggregatorsToMerge.add(metadata.getAggregators());
                }
                if (timestampSpecsToMerge != null && metadata.getTimestampSpec() != null) {
                    timestampSpecsToMerge.add(metadata.getTimestampSpec());
                }
                if (gransToMerge != null) {
                    gransToMerge.add(metadata.getQueryGranularity());
                }
                if (rollupToMerge != null) {
                    rollupToMerge.add(metadata.isRollup());
                }
                mergedContainer.putAll(metadata.container);
                continue;
            }
            aggregatorsToMerge = null;
            timestampSpecsToMerge = null;
            gransToMerge = null;
            rollupToMerge = null;
        }
        if (!foundSomeMetadata) {
            return null;
        }
        AggregatorFactory[] mergedAggregators = aggregatorsToMerge == null ? overrideMergedAggregators : AggregatorFactory.mergeAggregators(aggregatorsToMerge);
        TimestampSpec mergedTimestampSpec = timestampSpecsToMerge == null ? null : TimestampSpec.mergeTimestampSpec(timestampSpecsToMerge);
        Granularity mergedGranularity = gransToMerge == null ? null : Granularity.mergeGranularities(gransToMerge);
        Boolean rollup = null;
        if (rollupToMerge != null && !rollupToMerge.isEmpty()) {
            rollup = (Boolean)rollupToMerge.get(0);
            for (Boolean r : rollupToMerge) {
                if (r == null) {
                    rollup = null;
                    break;
                }
                if (!r.equals(rollup)) {
                    rollup = null;
                    break;
                }
                rollup = r;
            }
        }
        return new Metadata(mergedContainer, mergedAggregators, mergedTimestampSpec, mergedGranularity, rollup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.container, metadata.container) && Arrays.equals(this.aggregators, metadata.aggregators) && Objects.equals(this.timestampSpec, metadata.timestampSpec) && Objects.equals(this.queryGranularity, metadata.queryGranularity) && Objects.equals(this.rollup, metadata.rollup);
    }

    public int hashCode() {
        return Objects.hash(this.container, Arrays.hashCode(this.aggregators), this.timestampSpec, this.queryGranularity, this.rollup);
    }

    public String toString() {
        return "Metadata{container=" + this.container + ", aggregators=" + Arrays.toString(this.aggregators) + ", timestampSpec=" + this.timestampSpec + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + '}';
    }
}

