/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.segment.AbstractSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class QueryableIndexSegment
extends AbstractSegment {
    private final QueryableIndex index;
    private final QueryableIndexStorageAdapter storageAdapter;
    private final SegmentId segmentId;

    public QueryableIndexSegment(QueryableIndex index, SegmentId segmentId) {
        this.index = index;
        this.storageAdapter = new QueryableIndexStorageAdapter(index);
        this.segmentId = segmentId;
    }

    @Override
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public QueryableIndex asQueryableIndex() {
        return this.index;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return this.storageAdapter;
    }

    @Override
    public void close() {
        this.index.close();
    }
}

