/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.AbstractSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCounter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class ReferenceCountingSegment
extends AbstractSegment
implements Overshadowable<ReferenceCountingSegment>,
ReferenceCounter {
    private static final EmittingLogger log = new EmittingLogger(ReferenceCountingSegment.class);
    private final Segment baseSegment;
    private final short startRootPartitionId;
    private final short endRootPartitionId;
    private final short minorVersion;
    private final short atomicUpdateGroupSize;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Phaser referents = new Phaser(1){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            if (registeredParties != 0) {
                log.error("registeredParties[%s] is not 0", new Object[]{registeredParties});
            }
            try {
                ReferenceCountingSegment.this.baseSegment.close();
            }
            catch (Exception e) {
                try {
                    log.error((Throwable)e, "Exception while closing segment[%s]", new Object[]{ReferenceCountingSegment.this.baseSegment.getId()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
    };

    public static ReferenceCountingSegment wrapRootGenerationSegment(Segment baseSegment) {
        return new ReferenceCountingSegment((Segment)Preconditions.checkNotNull((Object)baseSegment, (Object)"baseSegment"), baseSegment.getId().getPartitionNum(), baseSegment.getId().getPartitionNum() + 1, 0, 1);
    }

    public static ReferenceCountingSegment wrapSegment(Segment baseSegment, ShardSpec shardSpec) {
        return new ReferenceCountingSegment(baseSegment, shardSpec.getStartRootPartitionId(), shardSpec.getEndRootPartitionId(), shardSpec.getMinorVersion(), shardSpec.getAtomicUpdateGroupSize());
    }

    private ReferenceCountingSegment(Segment baseSegment, int startRootPartitionId, int endRootPartitionId, short minorVersion, short atomicUpdateGroupSize) {
        this.baseSegment = baseSegment;
        this.startRootPartitionId = (short)startRootPartitionId;
        this.endRootPartitionId = (short)endRootPartitionId;
        this.minorVersion = minorVersion;
        this.atomicUpdateGroupSize = atomicUpdateGroupSize;
    }

    @Nullable
    public Segment getBaseSegment() {
        return !this.isClosed() ? this.baseSegment : null;
    }

    public int getNumReferences() {
        return Math.max(this.referents.getRegisteredParties() - 1, 0);
    }

    public boolean isClosed() {
        return this.referents.isTerminated();
    }

    @Override
    @Nullable
    public SegmentId getId() {
        return !this.isClosed() ? this.baseSegment.getId() : null;
    }

    @Override
    @Nullable
    public Interval getDataInterval() {
        return !this.isClosed() ? this.baseSegment.getDataInterval() : null;
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return !this.isClosed() ? this.baseSegment.asQueryableIndex() : null;
    }

    @Override
    @Nullable
    public StorageAdapter asStorageAdapter() {
        return !this.isClosed() ? this.baseSegment.asStorageAdapter() : null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.referents.arriveAndDeregister();
        } else {
            log.warn("close() is called more than once on ReferenceCountingSegment", new Object[0]);
        }
    }

    public ReferenceCounter referenceCounter() {
        return this;
    }

    @Override
    public boolean increment() {
        return this.referents.register() >= 0;
    }

    @Override
    public Closeable decrementOnceCloseable() {
        AtomicBoolean decremented = new AtomicBoolean(false);
        return () -> {
            if (decremented.compareAndSet(false, true)) {
                this.decrement();
            } else {
                log.warn("close() is called more than once on ReferenceCountingSegment.decrementOnceCloseable()", new Object[0]);
            }
        };
    }

    @Override
    public void decrement() {
        this.referents.arriveAndDeregister();
    }

    @Override
    public <T> T as(Class<T> clazz) {
        return this.getBaseSegment().as(clazz);
    }

    public boolean overshadows(ReferenceCountingSegment other) {
        if (this.baseSegment.getId().getDataSource().equals(other.baseSegment.getId().getDataSource()) && this.baseSegment.getId().getInterval().overlaps((ReadableInterval)other.baseSegment.getId().getInterval())) {
            int majorVersionCompare = this.baseSegment.getId().getVersion().compareTo(other.baseSegment.getId().getVersion());
            if (majorVersionCompare > 0) {
                return true;
            }
            if (majorVersionCompare == 0) {
                return this.includeRootPartitions(other) && this.getMinorVersion() > other.getMinorVersion();
            }
        }
        return false;
    }

    private boolean includeRootPartitions(ReferenceCountingSegment other) {
        return this.startRootPartitionId <= other.startRootPartitionId && this.endRootPartitionId >= other.endRootPartitionId;
    }

    public int getStartRootPartitionId() {
        return this.startRootPartitionId;
    }

    public int getEndRootPartitionId() {
        return this.endRootPartitionId;
    }

    public String getVersion() {
        return this.baseSegment.getId().getVersion();
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short getAtomicUpdateGroupSize() {
        return this.atomicUpdateGroupSize;
    }
}

