/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarFloatsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class EntireLayoutColumnarFloatsSerializer
implements ColumnarFloatsSerializer {
    private static final MetaSerdeHelper<EntireLayoutColumnarFloatsSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 2).writeInt(x -> x.numInserted).writeInt(x -> 0).writeByte(x -> CompressionStrategy.NONE.getId());
    private final String columnName;
    private final boolean isLittleEndian;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private WriteOutBytes valuesOut;
    private int numInserted = 0;

    EntireLayoutColumnarFloatsSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder order) {
        this.columnName = columnName;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.isLittleEndian = order.equals(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(float value) throws IOException {
        int valueBits = Float.floatToRawIntBits(value);
        if (this.isLittleEndian) {
            valueBits = Integer.reverseBytes(valueBits);
        }
        this.valuesOut.writeInt(valueBits);
        ++this.numInserted;
        if (this.numInserted < 0) {
            throw new ColumnCapacityExceededException(this.columnName);
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        return (long)META_SERDE_HELPER.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        META_SERDE_HELPER.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }
}

