/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import org.apache.druid.segment.data.CompressionFactory;

public class LongsLongEncodingReader
implements CompressionFactory.LongEncodingReader {
    private LongBuffer buffer;

    public LongsLongEncodingReader(ByteBuffer fromBuffer, ByteOrder order) {
        this.buffer = fromBuffer.asReadOnlyBuffer().order(order).asLongBuffer();
    }

    private LongsLongEncodingReader(LongBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer.asLongBuffer();
    }

    @Override
    public long read(int index) {
        return this.buffer.get(this.buffer.position() + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long[] out, int outPosition, int startIndex, int length) {
        int oldPosition = this.buffer.position();
        try {
            this.buffer.position(oldPosition + startIndex);
            this.buffer.get(out, outPosition, length);
        }
        finally {
            this.buffer.position(oldPosition);
        }
    }

    @Override
    public CompressionFactory.LongEncodingReader duplicate() {
        return new LongsLongEncodingReader(this.buffer.duplicate());
    }
}

