/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.PredicateValueMatcherFactory;
import org.apache.druid.segment.filter.ValueMatchers;

public class ConstantValueMatcherFactory
implements ColumnProcessorFactory<ValueMatcher> {
    @Nullable
    private final String matchValue;

    ConstantValueMatcherFactory(@Nullable String matchValue) {
        this.matchValue = NullHandling.emptyToNullIfNeeded((String)matchValue);
    }

    @Override
    public ValueType defaultType() {
        return ValueType.COMPLEX;
    }

    @Override
    public ValueMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
        return ValueMatchers.makeStringValueMatcher(selector, this.matchValue, multiValue);
    }

    @Override
    public ValueMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
        return ValueMatchers.makeFloatValueMatcher(selector, this.matchValue);
    }

    @Override
    public ValueMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
        return ValueMatchers.makeDoubleValueMatcher(selector, this.matchValue);
    }

    @Override
    public ValueMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
        return ValueMatchers.makeLongValueMatcher(selector, this.matchValue);
    }

    @Override
    public ValueMatcher makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
        return new PredicateValueMatcherFactory(new SelectorPredicateFactory(this.matchValue)).makeComplexProcessor((BaseObjectColumnValueSelector)selector);
    }
}

