/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.AbstractSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.join.HashJoinSegmentStorageAdapter;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class HashJoinSegment
extends AbstractSegment {
    private final Segment baseSegment;
    private final List<JoinableClause> clauses;
    private final JoinFilterPreAnalysis joinFilterPreAnalysis;

    public HashJoinSegment(Segment baseSegment, List<JoinableClause> clauses, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        this.baseSegment = baseSegment;
        this.clauses = clauses;
        this.joinFilterPreAnalysis = joinFilterPreAnalysis;
        if (clauses.isEmpty()) {
            throw new IAE("'clauses' is empty, no need to create HashJoinSegment", new Object[0]);
        }
    }

    @Override
    public SegmentId getId() {
        return this.baseSegment.getId();
    }

    @Override
    public Interval getDataInterval() {
        return this.baseSegment.getDataInterval();
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new HashJoinSegmentStorageAdapter(this.baseSegment.asStorageAdapter(), this.clauses, this.joinFilterPreAnalysis);
    }

    @Override
    public void close() throws IOException {
        this.baseSegment.close();
    }
}

