/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.filter.JoinFilterAnalyzer;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.utils.JvmUtils;

public class Joinables {
    private static final Comparator<String> DESCENDING_LENGTH_STRING_COMPARATOR = (s1, s2) -> Integer.compare(s2.length(), s1.length());

    public static String validatePrefix(@Nullable String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            throw new IAE("Join clause cannot have null or empty prefix", new Object[0]);
        }
        if (Joinables.isPrefixedBy("__time", prefix) || "__time".equals(prefix)) {
            throw new IAE("Join clause cannot have prefix[%s], since it would shadow %s", new Object[]{prefix, "__time"});
        }
        return prefix;
    }

    public static boolean isPrefixedBy(String columnName, String prefix) {
        return columnName.length() > prefix.length() && columnName.startsWith(prefix);
    }

    public static Function<Segment, Segment> createSegmentMapFn(List<PreJoinableClause> clauses, JoinableFactory joinableFactory, AtomicLong cpuTimeAccumulator, boolean enableFilterPushDown, boolean enableFilterRewrite, boolean enableRewriteValueColumnFilters, long filterRewriteMaxSize, Filter originalFilter, VirtualColumns virtualColumns) {
        return (Function)JvmUtils.safeAccumulateThreadCpuTime((AtomicLong)cpuTimeAccumulator, () -> {
            if (clauses.isEmpty()) {
                return Function.identity();
            }
            List<JoinableClause> joinableClauses = Joinables.createJoinableClauses(clauses, joinableFactory);
            JoinFilterPreAnalysis jfpa = JoinFilterAnalyzer.computeJoinFilterPreAnalysis(joinableClauses, virtualColumns, originalFilter, enableFilterPushDown, enableFilterRewrite, enableRewriteValueColumnFilters, filterRewriteMaxSize);
            return baseSegment -> new HashJoinSegment((Segment)baseSegment, joinableClauses, jfpa);
        });
    }

    private static List<JoinableClause> createJoinableClauses(List<PreJoinableClause> clauses, JoinableFactory joinableFactory) {
        Joinables.checkPreJoinableClausesForDuplicatesAndShadowing(clauses);
        return clauses.stream().map(preJoinableClause -> {
            Optional<Joinable> joinable = joinableFactory.build(preJoinableClause.getDataSource(), preJoinableClause.getCondition());
            return new JoinableClause(preJoinableClause.getPrefix(), joinable.orElseThrow(() -> new ISE("dataSource is not joinable: %s", new Object[]{preJoinableClause.getDataSource()})), preJoinableClause.getJoinType(), preJoinableClause.getCondition());
        }).collect(Collectors.toList());
    }

    private static void checkPreJoinableClausesForDuplicatesAndShadowing(List<PreJoinableClause> preJoinableClauses) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (PreJoinableClause clause : preJoinableClauses) {
            prefixes.add(clause.getPrefix());
        }
        Joinables.checkPrefixesForDuplicatesAndShadowing(prefixes);
    }

    public static void checkPrefixesForDuplicatesAndShadowing(List<String> prefixes) {
        prefixes.sort(DESCENDING_LENGTH_STRING_COMPARATOR);
        for (int i = 0; i < prefixes.size(); ++i) {
            String prefix = prefixes.get(i);
            for (int k = i + 1; k < prefixes.size(); ++k) {
                String otherPrefix = prefixes.get(k);
                if (prefix.equals(otherPrefix)) {
                    throw new IAE("Detected duplicate prefix in join clauses: [%s]", new Object[]{prefix});
                }
                if (!Joinables.isPrefixedBy(prefix, otherPrefix)) continue;
                throw new IAE("Detected conflicting prefixes in join clauses: [%s, %s]", new Object[]{prefix, otherPrefix});
            }
        }
    }
}

