/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.VirtualColumn;

public class JoinFilterAnalysis {
    private final boolean retainAfterJoin;
    private final Filter originalFilter;
    private final Optional<Filter> pushDownFilter;
    private final List<VirtualColumn> pushDownVirtualColumns;

    public JoinFilterAnalysis(boolean retainAfterJoin, Filter originalFilter, @Nullable Filter pushDownFilter, List<VirtualColumn> pushDownVirtualColumns) {
        this.retainAfterJoin = retainAfterJoin;
        this.originalFilter = originalFilter;
        this.pushDownFilter = pushDownFilter == null ? Optional.empty() : Optional.of(pushDownFilter);
        this.pushDownVirtualColumns = pushDownVirtualColumns;
    }

    public boolean isCanPushDown() {
        return this.pushDownFilter.isPresent();
    }

    public boolean isRetainAfterJoin() {
        return this.retainAfterJoin;
    }

    public Filter getOriginalFilter() {
        return this.originalFilter;
    }

    public Optional<Filter> getPushDownFilter() {
        return this.pushDownFilter;
    }

    public List<VirtualColumn> getPushDownVirtualColumns() {
        return this.pushDownVirtualColumns;
    }

    public static JoinFilterAnalysis createNoPushdownFilterAnalysis(Filter originalFilter) {
        return new JoinFilterAnalysis(true, originalFilter, null, (List<VirtualColumn>)ImmutableList.of());
    }
}

