/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.lookup.LookupColumnSelectorFactory;

public class LookupJoinMatcher
implements JoinMatcher {
    private static final ColumnProcessorFactory<Supplier<String>> LEFT_KEY_READER = new ColumnProcessorFactory<Supplier<String>>(){

        @Override
        public ValueType defaultType() {
            return ValueType.STRING;
        }

        @Override
        public Supplier<String> makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            return () -> {
                IndexedInts row = selector.getRow();
                if (row.size() == 1) {
                    return selector.lookupName(row.get(0));
                }
                return null;
            };
        }

        @Override
        public Supplier<String> makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> DimensionHandlerUtils.convertObjectToString(Float.valueOf(selector.getFloat()));
            }
            return () -> selector.isNull() ? null : DimensionHandlerUtils.convertObjectToString(Float.valueOf(selector.getFloat()));
        }

        @Override
        public Supplier<String> makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> DimensionHandlerUtils.convertObjectToString(selector.getDouble());
            }
            return () -> selector.isNull() ? null : DimensionHandlerUtils.convertObjectToString(selector.getDouble());
        }

        @Override
        public Supplier<String> makeLongProcessor(BaseLongColumnValueSelector selector) {
            if (NullHandling.replaceWithDefault()) {
                return () -> DimensionHandlerUtils.convertObjectToString(selector.getLong());
            }
            return () -> selector.isNull() ? null : DimensionHandlerUtils.convertObjectToString(selector.getLong());
        }

        @Override
        public Supplier<String> makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return () -> null;
        }
    };
    @Nullable
    private Iterator<Map.Entry<String, String>> currentIterator = null;
    private final SettableSupplier<Pair<String, String>> currentEntry = new SettableSupplier();
    private final LookupExtractor extractor;
    private final JoinConditionAnalysis condition;
    private final List<Supplier<String>> keySuppliers;
    private final ColumnSelectorFactory selectorFactory = new LookupColumnSelectorFactory(() -> this.currentEntry.get());
    private boolean matchingRemainder = false;
    private final Set<String> matchedKeys;

    private LookupJoinMatcher(LookupExtractor extractor, ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, @Nullable List<Expr> keyExprs, boolean remainderNeeded) {
        this.extractor = extractor;
        this.matchedKeys = remainderNeeded && !condition.isAlwaysTrue() && !condition.isAlwaysFalse() ? new HashSet() : null;
        this.condition = condition;
        if (keyExprs != null) {
            this.keySuppliers = keyExprs.stream().map(expr -> ColumnProcessors.makeProcessor(expr, ValueType.STRING, LEFT_KEY_READER, leftSelectorFactory)).collect(Collectors.toList());
        } else {
            Preconditions.checkState((condition.isAlwaysFalse() || condition.isAlwaysTrue() ? 1 : 0) != 0, (Object)"Condition must be always true or always false when keySuppliers == null");
            this.keySuppliers = null;
        }
        if (condition.isAlwaysTrue() || remainderNeeded) {
            Preconditions.checkState((boolean)extractor.canIterate(), (Object)"Cannot iterate lookup, but iteration is required for this join");
        }
    }

    public static LookupJoinMatcher create(LookupExtractor extractor, ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded) {
        List keyExprs;
        if (condition.isAlwaysTrue()) {
            keyExprs = null;
        } else if (condition.isAlwaysFalse()) {
            keyExprs = null;
        } else {
            if (!condition.getNonEquiConditions().isEmpty()) {
                throw new IAE("Cannot join lookup with non-equi condition: %s", new Object[]{condition});
            }
            if (!condition.getRightEquiConditionKeys().stream().allMatch("k"::equals)) {
                throw new IAE("Cannot join lookup with condition referring to non-key column: %s", new Object[]{condition});
            }
            keyExprs = condition.getEquiConditions().stream().map(Equality::getLeftExpr).collect(Collectors.toList());
        }
        return new LookupJoinMatcher(extractor, leftSelectorFactory, condition, keyExprs, remainderNeeded);
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.selectorFactory;
    }

    @Override
    public void matchCondition() {
        this.currentIterator = null;
        this.matchingRemainder = false;
        if (this.condition.isAlwaysFalse()) {
            this.currentEntry.set(null);
        } else if (this.condition.isAlwaysTrue()) {
            this.currentIterator = this.extractor.iterable().iterator();
            this.nextMatch();
        } else {
            if (this.keySuppliers.isEmpty()) {
                this.currentEntry.set(null);
                return;
            }
            Iterator<Supplier<String>> keySupplierIterator = this.keySuppliers.iterator();
            String theKey = keySupplierIterator.next().get();
            if (theKey == null) {
                this.currentEntry.set(null);
                return;
            }
            while (keySupplierIterator.hasNext()) {
                if (theKey.equals(keySupplierIterator.next().get())) continue;
                this.currentEntry.set(null);
                return;
            }
            this.checkInLookup(theKey);
        }
    }

    private void checkInLookup(String theKey) {
        String theValue = this.extractor.apply(theKey);
        if (theValue != null) {
            assert (theKey != null);
            this.currentEntry.set((Object)Pair.of((Object)theKey, (Object)theValue));
            if (this.matchedKeys != null) {
                this.matchedKeys.add(theKey);
            }
        } else {
            this.currentEntry.set(null);
        }
    }

    @Override
    public void matchRemainder() {
        this.matchingRemainder = true;
        this.currentIterator = this.condition.isAlwaysFalse() ? this.extractor.iterable().iterator() : (this.condition.isAlwaysTrue() ? Collections.emptyIterator() : Iterators.filter(this.extractor.iterable().iterator(), entry -> !this.matchedKeys.contains(entry.getKey())));
        this.nextMatch();
    }

    @Override
    public boolean hasMatch() {
        return this.currentEntry.get() != null;
    }

    @Override
    public boolean matchingRemainder() {
        return this.matchingRemainder;
    }

    @Override
    public void nextMatch() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            Map.Entry<String, String> entry = this.currentIterator.next();
            this.currentEntry.set((Object)Pair.of((Object)entry.getKey(), (Object)entry.getValue()));
        } else {
            this.currentIterator = null;
            this.currentEntry.set(null);
        }
    }

    @Override
    public void reset() {
        this.currentEntry.set(null);
        this.currentIterator = null;
        this.matchingRemainder = false;
    }
}

