/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ComplexColumnSerializer<T>
implements GenericColumnSerializer<T> {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ObjectStrategy strategy;
    private GenericIndexedWriter writer;

    public static ComplexColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy) {
        return new ComplexColumnSerializer(segmentWriteOutMedium, filenameBase, strategy);
    }

    private ComplexColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.segmentWriteOutMedium, StringUtils.format((String)"%s.complex_column", (Object[])new Object[]{this.filenameBase}), this.strategy);
        this.writer.open();
    }

    @Override
    public void serialize(ColumnValueSelector<? extends T> selector) throws IOException {
        this.writer.write(selector.getObject());
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeToVersionOne(channel);
    }

    private void writeToVersionOne(WritableByteChannel channel) throws IOException {
        this.writer.writeTo(channel, null);
    }
}

