/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;

public class MultiValueExpressionDimensionSelector
implements DimensionSelector {
    private final ColumnValueSelector<ExprEval> baseSelector;

    public MultiValueExpressionDimensionSelector(ColumnValueSelector<ExprEval> baseSelector) {
        this.baseSelector = baseSelector;
    }

    ExprEval getEvaluated() {
        return (ExprEval)this.baseSelector.getObject();
    }

    String getValue(ExprEval evaluated) {
        assert (!evaluated.isArray());
        return NullHandling.emptyToNullIfNeeded((String)evaluated.asString());
    }

    List<String> getArray(ExprEval evaluated) {
        assert (evaluated.isArray());
        return Arrays.stream(evaluated.asStringArray()).map(NullHandling::emptyToNullIfNeeded).collect(Collectors.toList());
    }

    String getArrayValue(ExprEval evaluated, int i) {
        assert (evaluated.isArray());
        String[] stringArray = evaluated.asStringArray();
        assert (i < stringArray.length);
        return NullHandling.emptyToNullIfNeeded((String)stringArray[i]);
    }

    @Override
    public IndexedInts getRow() {
        ExprEval evaluated = this.getEvaluated();
        if (evaluated.isArray()) {
            RangeIndexedInts ints = new RangeIndexedInts();
            ints.setSize(evaluated.asArray() != null ? evaluated.asArray().length : 0);
            return ints;
        }
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        ExprEval evaluated = this.getEvaluated();
        if (evaluated.isArray()) {
            return this.getArrayValue(evaluated, id);
        }
        assert (id == 0);
        return NullHandling.emptyToNullIfNeeded((String)evaluated.asString());
    }

    @Override
    public ValueMatcher makeValueMatcher(final @Nullable String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                ExprEval evaluated = MultiValueExpressionDimensionSelector.this.getEvaluated();
                if (evaluated.isArray()) {
                    List<String> array = MultiValueExpressionDimensionSelector.this.getArray(evaluated);
                    return array.stream().anyMatch(x -> Objects.equals(x, value));
                }
                return Objects.equals(MultiValueExpressionDimensionSelector.this.getValue(evaluated), value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", MultiValueExpressionDimensionSelector.this.baseSelector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                ExprEval evaluated = MultiValueExpressionDimensionSelector.this.getEvaluated();
                if (evaluated.isArray()) {
                    List<String> array = MultiValueExpressionDimensionSelector.this.getArray(evaluated);
                    return array.stream().anyMatch(x -> predicate.apply(x));
                }
                return predicate.apply((Object)MultiValueExpressionDimensionSelector.this.getValue(evaluated));
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", MultiValueExpressionDimensionSelector.this.baseSelector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("baseSelector", this.baseSelector);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        ExprEval evaluated = this.getEvaluated();
        if (evaluated.isArray()) {
            return this.getArray(evaluated);
        }
        return this.getValue(evaluated);
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }
}

