/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.first.StringFirstAggregateCombiner;
import org.apache.druid.query.aggregation.first.StringFirstAggregator;
import org.apache.druid.query.aggregation.first.StringFirstBufferAggregator;
import org.apache.druid.query.aggregation.first.StringFirstLastUtils;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;

@JsonTypeName(value="stringFirst")
public class StringFirstAggregatorFactory
extends AggregatorFactory {
    private static final Aggregator NIL_AGGREGATOR = new StringFirstAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), (BaseObjectColumnValueSelector)NilColumnValueSelector.instance(), 0, false){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new StringFirstBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), (BaseObjectColumnValueSelector)NilColumnValueSelector.instance(), 0, false){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    public static final int DEFAULT_MAX_STRING_SIZE = 1024;
    public static final Comparator TIME_COMPARATOR = (o1, o2) -> Longs.compare((long)((Long)((SerializablePairLongString)((Object)((Object)o1))).lhs), (long)((Long)((SerializablePairLongString)((Object)((Object)o2))).lhs));
    public static final Comparator<SerializablePairLongString> VALUE_COMPARATOR = (o1, o2) -> {
        int comparation;
        if (o1 == null && o2 == null) {
            comparation = 0;
        } else if (o1 == null) {
            comparation = -1;
        } else if (o2 == null) {
            comparation = 1;
        } else {
            comparation = ((Long)o1.lhs).compareTo((Long)o2.lhs);
            if (comparation == 0) {
                comparation = o1.rhs == null && o2.rhs == null ? 0 : (o1.rhs == null ? -1 : (o2.rhs == null ? 1 : ((String)o1.rhs).compareTo((String)o2.rhs)));
            }
        }
        return comparation;
    };
    private final String fieldName;
    private final String name;
    protected final int maxStringBytes;

    @JsonCreator
    public StringFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="maxStringBytes") Integer maxStringBytes) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        if (maxStringBytes != null && maxStringBytes < 0) {
            throw new IAE("maxStringBytes must be greater than 0", new Object[0]);
        }
        this.name = name;
        this.fieldName = fieldName;
        this.maxStringBytes = maxStringBytes == null ? 1024 : maxStringBytes;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new StringFirstAggregator(metricFactory.makeColumnValueSelector("__time"), valueSelector, this.maxStringBytes, StringFirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName)));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new StringFirstBufferAggregator(metricFactory.makeColumnValueSelector("__time"), valueSelector, this.maxStringBytes, StringFirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName)));
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return TIME_COMPARATOR.compare(lhs, rhs) > 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new StringFirstAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new StringFirstAggregatorFactory(this.name, this.name, this.maxStringBytes);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new StringFirstAggregatorFactory(this.fieldName, this.fieldName, this.maxStringBytes));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePairLongString(((Number)map.get("lhs")).longValue(), (String)map.get("rhs"));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : ((SerializablePairLongString)((Object)object)).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public Integer getMaxStringBytes() {
        return this.maxStringBytes;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(43).appendString(this.fieldName).appendInt(this.maxStringBytes).build();
    }

    @Override
    public String getTypeName() {
        return "serializablePairLongString";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 12 + this.maxStringBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringFirstAggregatorFactory that = (StringFirstAggregatorFactory)o;
        return this.maxStringBytes == that.maxStringBytes && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name, this.maxStringBytes);
    }

    public String toString() {
        return "StringFirstAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", maxStringBytes=" + this.maxStringBytes + '}';
    }
}

