/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.Rows;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;

public class RowBasedColumnSelectorFactory<T>
implements ColumnSelectorFactory {
    private final Supplier<T> supplier;
    private final RowAdapter<T> adapter;
    private final RowSignature rowSignature;
    private final boolean throwParseExceptions;

    private RowBasedColumnSelectorFactory(Supplier<T> supplier, RowAdapter<T> adapter, RowSignature rowSignature, boolean throwParseExceptions) {
        this.supplier = supplier;
        this.adapter = adapter;
        this.rowSignature = (RowSignature)Preconditions.checkNotNull((Object)rowSignature, (Object)"rowSignature must be nonnull");
        this.throwParseExceptions = throwParseExceptions;
    }

    public static <RowType> RowBasedColumnSelectorFactory<RowType> create(RowAdapter<RowType> adapter, Supplier<RowType> supplier, RowSignature signature, boolean throwParseExceptions) {
        return new RowBasedColumnSelectorFactory<RowType>(supplier, adapter, signature, throwParseExceptions);
    }

    @Nullable
    static ColumnCapabilities getColumnCapabilities(RowSignature rowSignature, String columnName) {
        if ("__time".equals(columnName)) {
            return new ColumnCapabilitiesImpl().setType(ValueType.LONG).setIsComplete(true);
        }
        ValueType valueType = rowSignature.getColumnType(columnName).orElse(null);
        if (valueType != null) {
            return new ColumnCapabilitiesImpl().setType(valueType).setDictionaryValuesUnique(false).setDictionaryValuesSorted(false).setIsComplete(valueType.isNumeric());
        }
        return null;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if ("__time".equals(dimensionSpec.getDimension())) {
            if (extractionFn == null) {
                throw new UnsupportedOperationException("time dimension must provide an extraction function");
            }
            final ToLongFunction<T> timestampFunction = this.adapter.timestampFunction();
            return new BaseSingleValueDimensionSelector(){

                @Override
                protected String getValue() {
                    return extractionFn.apply(timestampFunction.applyAsLong(RowBasedColumnSelectorFactory.this.supplier.get()));
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                    inspector.visit("extractionFn", extractionFn);
                }
            };
        }
        final Function<T, Object> dimFunction = this.adapter.columnFunction(dimension);
        return new DimensionSelector(){
            private final RangeIndexedInts indexedInts = new RangeIndexedInts();

            @Override
            public IndexedInts getRow() {
                List dimensionValues = Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get()));
                this.indexedInts.setSize(dimensionValues != null ? dimensionValues.size() : 0);
                return this.indexedInts;
            }

            @Override
            public ValueMatcher makeValueMatcher(final @Nullable String value) {
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List dimensionValues = Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get()));
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return value == null;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!Objects.equals(NullHandling.emptyToNullIfNeeded((String)dimensionValue), value)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List dimensionValues = Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get()));
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return value == null;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!Objects.equals(extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)dimensionValue)), value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                        inspector.visit("extractionFn", extractionFn);
                    }
                };
            }

            @Override
            public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
                final boolean matchNull = predicate.apply(null);
                if (extractionFn == null) {
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            List dimensionValues = Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get()));
                            if (dimensionValues == null || dimensionValues.isEmpty()) {
                                return matchNull;
                            }
                            for (String dimensionValue : dimensionValues) {
                                if (!predicate.apply((Object)NullHandling.emptyToNullIfNeeded((String)dimensionValue))) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                            inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                            inspector.visit("predicate", predicate);
                        }
                    };
                }
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        List dimensionValues = Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get()));
                        if (dimensionValues == null || dimensionValues.isEmpty()) {
                            return matchNull;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!predicate.apply((Object)extractionFn.apply(NullHandling.emptyToNullIfNeeded((String)dimensionValue)))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                        inspector.visit("predicate", predicate);
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return -1;
            }

            @Override
            public String lookupName(int id) {
                String value = NullHandling.emptyToNullIfNeeded((String)((String)Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get())).get(id)));
                return extractionFn == null ? value : extractionFn.apply(value);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            @Nullable
            public Object getObject() {
                List dimensionValues = Rows.objectToStrings(dimFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get()));
                if (dimensionValues == null) {
                    return null;
                }
                if (dimensionValues.size() == 1) {
                    return dimensionValues.get(0);
                }
                return dimensionValues;
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                inspector.visit("extractionFn", extractionFn);
            }
        };
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final String columnName) {
        if (columnName.equals("__time")) {
            final ToLongFunction<T> timestampFunction = this.adapter.timestampFunction();
            class TimeLongColumnSelector
            implements LongColumnSelector {
                TimeLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    return timestampFunction.applyAsLong(RowBasedColumnSelectorFactory.this.supplier.get());
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
                }
            }
            return new TimeLongColumnSelector();
        }
        final Function<T, Object> columnFunction = this.adapter.columnFunction(columnName);
        return new ColumnValueSelector<Object>(){

            @Override
            public boolean isNull() {
                return !NullHandling.replaceWithDefault() && this.getCurrentValueAsNumber() == null;
            }

            @Override
            public double getDouble() {
                Number n = this.getCurrentValueAsNumber();
                assert (NullHandling.replaceWithDefault() || n != null);
                return n != null ? n.doubleValue() : 0.0;
            }

            @Override
            public float getFloat() {
                Number n = this.getCurrentValueAsNumber();
                assert (NullHandling.replaceWithDefault() || n != null);
                return n != null ? n.floatValue() : 0.0f;
            }

            @Override
            public long getLong() {
                Number n = this.getCurrentValueAsNumber();
                assert (NullHandling.replaceWithDefault() || n != null);
                return n != null ? n.longValue() : 0L;
            }

            @Override
            @Nullable
            public Object getObject() {
                return this.getCurrentValue();
            }

            @Override
            public Class<Object> classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.supplier);
            }

            @Nullable
            private Object getCurrentValue() {
                return columnFunction.apply(RowBasedColumnSelectorFactory.this.supplier.get());
            }

            @Nullable
            private Number getCurrentValueAsNumber() {
                return Rows.objectToNumber((String)columnName, (Object)this.getCurrentValue(), (boolean)RowBasedColumnSelectorFactory.this.throwParseExceptions);
            }
        };
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return RowBasedColumnSelectorFactory.getColumnCapabilities(this.rowSignature, columnName);
    }
}

