/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.segment.AbstractSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class RowBasedSegment<RowType>
extends AbstractSegment {
    private final SegmentId segmentId;
    private final StorageAdapter storageAdapter;

    public RowBasedSegment(SegmentId segmentId, Iterable<RowType> rowIterable, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this.segmentId = (SegmentId)Preconditions.checkNotNull((Object)segmentId, (Object)"segmentId");
        this.storageAdapter = new RowBasedStorageAdapter<RowType>(rowIterable, rowAdapter, rowSignature);
    }

    @Override
    @Nonnull
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    @Nonnull
    public Interval getDataInterval() {
        return this.storageAdapter.getInterval();
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    @Nonnull
    public StorageAdapter asStorageAdapter() {
        return this.storageAdapter;
    }

    @Override
    public void close() {
    }
}

