/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ObjectStrategy;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class RoaringBitmapSerdeFactory
implements BitmapSerdeFactory {
    public static final boolean DEFAULT_COMPRESS_RUN_ON_SERIALIZATION = true;
    private static final ObjectStrategy<ImmutableBitmap> OBJECT_STRATEGY = new ImmutableRoaringBitmapObjectStrategy();
    private final boolean compressRunOnSerialization;
    private final BitmapFactory bitmapFactory;

    @JsonCreator
    public RoaringBitmapSerdeFactory(@JsonProperty(value="compressRunOnSerialization") @Nullable Boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization == null ? true : compressRunOnSerialization;
        this.bitmapFactory = new RoaringBitmapFactory(this.compressRunOnSerialization);
    }

    @JsonProperty
    public boolean getCompressRunOnSerialization() {
        return this.compressRunOnSerialization;
    }

    @Override
    public ObjectStrategy<ImmutableBitmap> getObjectStrategy() {
        return OBJECT_STRATEGY;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    public String toString() {
        return "RoaringBitmapSerdeFactory{}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RoaringBitmapSerdeFactory;
    }

    public int hashCode() {
        return 0;
    }

    private static class ImmutableRoaringBitmapObjectStrategy
    implements ObjectStrategy<ImmutableBitmap> {
        private ImmutableRoaringBitmapObjectStrategy() {
        }

        @Override
        public Class<ImmutableBitmap> getClazz() {
            return ImmutableBitmap.class;
        }

        @Override
        @Nullable
        public ImmutableBitmap fromByteBuffer(ByteBuffer buffer, int numBytes) {
            buffer.limit(buffer.position() + numBytes);
            return new WrappedImmutableRoaringBitmap(new ImmutableRoaringBitmap(buffer));
        }

        @Override
        @Nullable
        public byte[] toBytes(@Nullable ImmutableBitmap val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableBitmap o1, ImmutableBitmap o2) {
            throw new UnsupportedOperationException();
        }
    }
}

