/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Collections;
import java.util.Set;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.FalseValueMatcher;
import org.apache.druid.segment.filter.Filters;

public class FalseFilter
implements Filter {
    private static final FalseFilter INSTANCE = new FalseFilter();

    public static FalseFilter instance() {
        return INSTANCE;
    }

    private FalseFilter() {
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        return 0.0;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return FalseValueMatcher.instance();
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return true;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return true;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return Collections.emptySet();
    }

    public String toString() {
        return "false";
    }
}

