/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.IntIteratorUtils;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class InFilter
implements Filter {
    private final String dimension;
    private final Set<String> values;
    private final ExtractionFn extractionFn;
    private final FilterTuning filterTuning;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;
    private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
    private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

    public InFilter(String dimension, Set<String> values, Supplier<DruidLongPredicate> longPredicateSupplier, Supplier<DruidFloatPredicate> floatPredicateSupplier, Supplier<DruidDoublePredicate> doublePredicateSupplier, ExtractionFn extractionFn, FilterTuning filterTuning) {
        this.dimension = dimension;
        this.values = values;
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.longPredicateSupplier = longPredicateSupplier;
        this.floatPredicateSupplier = floatPredicateSupplier;
        this.doublePredicateSupplier = doublePredicateSupplier;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (this.extractionFn == null) {
            BitmapIndex bitmapIndex = selector.getBitmapIndex(this.dimension);
            return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable(bitmapIndex));
        }
        return Filters.matchPredicate(this.dimension, selector, bitmapResultFactory, this.getPredicateFactory().makeStringPredicate());
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        if (this.extractionFn == null) {
            BitmapIndex bitmapIndex = indexSelector.getBitmapIndex(this.dimension);
            return Filters.estimateSelectivity(bitmapIndex, IntIteratorUtils.toIntList(this.getBitmapIndexIterable(bitmapIndex).iterator()), indexSelector.getNumRows());
        }
        return Filters.estimateSelectivity(this.dimension, indexSelector, this.getPredicateFactory().makeStringPredicate());
    }

    private Iterable<ImmutableBitmap> getBitmapIterable(BitmapIndex bitmapIndex) {
        return Filters.bitmapsFromIndexes(this.getBitmapIndexIterable(bitmapIndex), bitmapIndex);
    }

    private IntIterable getBitmapIndexIterable(final BitmapIndex bitmapIndex) {
        return new IntIterable(){

            public IntIterator iterator() {
                return new IntIterator(){
                    Iterator<String> iterator;
                    {
                        this.iterator = InFilter.this.values.iterator();
                    }

                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    public int nextInt() {
                        return bitmapIndex.getIndex(this.iterator.next());
                    }
                };
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.getPredicateFactory());
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return DimensionHandlerUtils.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.getPredicateFactory());
    }

    @Override
    public boolean canVectorizeMatcher() {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return input -> InFilter.this.values.contains(InFilter.this.extractionFn.apply((String)input));
                }
                return input -> InFilter.this.values.contains(input);
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return input -> InFilter.this.values.contains(InFilter.this.extractionFn.apply(input));
                }
                return (DruidLongPredicate)InFilter.this.longPredicateSupplier.get();
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return input -> InFilter.this.values.contains(InFilter.this.extractionFn.apply(Float.valueOf(input)));
                }
                return (DruidFloatPredicate)InFilter.this.floatPredicateSupplier.get();
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                if (InFilter.this.extractionFn != null) {
                    return input -> InFilter.this.values.contains(InFilter.this.extractionFn.apply(input));
                }
                return input -> ((DruidDoublePredicate)InFilter.this.doublePredicateSupplier.get()).applyDouble(input);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InFilter inFilter = (InFilter)o;
        return Objects.equals(this.dimension, inFilter.dimension) && Objects.equals(this.values, inFilter.values) && Objects.equals(this.extractionFn, inFilter.extractionFn) && Objects.equals(this.filterTuning, inFilter.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.values, this.extractionFn, this.filterTuning);
    }
}

