/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter.cnf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.TrueFilter;

public class CalciteCnfHelper {
    public static Filter pull(Filter rex) {
        if (rex instanceof AndFilter) {
            Set<Filter> operands = ((AndFilter)rex).getFilters();
            return CalciteCnfHelper.and(CalciteCnfHelper.pullList(operands));
        }
        if (rex instanceof OrFilter) {
            Set<Filter> operands = ((OrFilter)rex).getFilters();
            Map<Filter, Filter> factors = CalciteCnfHelper.commonFactors(operands);
            if (factors.isEmpty()) {
                return CalciteCnfHelper.or(operands);
            }
            ArrayList<Filter> list = new ArrayList<Filter>();
            for (Filter operand : operands) {
                Filter removed = CalciteCnfHelper.removeFactor(factors, operand);
                list.add(removed);
            }
            if (list.isEmpty()) {
                return CalciteCnfHelper.and(factors.values());
            }
            if (list.size() == 1) {
                return CalciteCnfHelper.and(Iterables.concat(factors.values(), (Iterable)ImmutableList.of(list.get(0))));
            }
            return CalciteCnfHelper.and(Iterables.concat(factors.values(), (Iterable)ImmutableList.of((Object)CalciteCnfHelper.or(list))));
        }
        return rex;
    }

    private static List<Filter> pullList(Set<Filter> nodes) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter node : nodes) {
            Filter pulled = CalciteCnfHelper.pull(node);
            if (pulled instanceof AndFilter) {
                list.addAll(((AndFilter)pulled).getFilters());
                continue;
            }
            list.add(pulled);
        }
        return list;
    }

    private static Map<Filter, Filter> commonFactors(Set<Filter> nodes) {
        HashMap<Filter, Filter> map = new HashMap<Filter, Filter>();
        int i = 0;
        for (Filter node : nodes) {
            if (i++ == 0) {
                for (Filter conjunction : CalciteCnfHelper.conjunctions(node)) {
                    map.put(conjunction, conjunction);
                }
                continue;
            }
            map.keySet().retainAll(CalciteCnfHelper.conjunctions(node));
        }
        return map;
    }

    private static Filter removeFactor(Map<Filter, Filter> factors, Filter node) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter operand : CalciteCnfHelper.conjunctions(node)) {
            if (factors.containsKey(operand)) continue;
            list.add(operand);
        }
        return CalciteCnfHelper.and(list);
    }

    private static Filter and(Iterable<? extends Filter> nodes) {
        return CalciteCnfHelper.composeConjunction(nodes);
    }

    private static Filter or(Iterable<? extends Filter> nodes) {
        return CalciteCnfHelper.composeDisjunction(nodes);
    }

    @Nonnull
    public static Filter composeConjunction(Iterable<? extends Filter> nodes) {
        Filter e = CalciteCnfHelper.composeConjunction(nodes, false);
        return Objects.requireNonNull(e);
    }

    public static Filter composeConjunction(Iterable<? extends Filter> nodes, boolean nullOnEmpty) {
        ImmutableList<Filter> list = CalciteCnfHelper.flattenAnd(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : TrueFilter.instance();
            }
            case 1: {
                return (Filter)list.get(0);
            }
        }
        return new AndFilter((List<Filter>)list);
    }

    public static ImmutableList<Filter> flattenAnd(Iterable<? extends Filter> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<Filter> set = new HashSet<Filter>();
        for (Filter filter : nodes) {
            if (filter == null) continue;
            CalciteCnfHelper.addAnd((ImmutableList.Builder<Filter>)builder, set, filter);
        }
        return builder.build();
    }

    private static void addAnd(ImmutableList.Builder<Filter> builder, Set<Filter> digests, Filter node) {
        if (node instanceof AndFilter) {
            for (Filter operand : ((AndFilter)node).getFilters()) {
                CalciteCnfHelper.addAnd(builder, digests, operand);
            }
        } else if (!(node instanceof TrueFilter) && digests.add(node)) {
            builder.add((Object)node);
        }
    }

    @Nonnull
    public static Filter composeDisjunction(Iterable<? extends Filter> nodes) {
        Filter e = CalciteCnfHelper.composeDisjunction(nodes, false);
        return Objects.requireNonNull(e);
    }

    public static Filter composeDisjunction(Iterable<? extends Filter> nodes, boolean nullOnEmpty) {
        ImmutableList<Filter> list = CalciteCnfHelper.flattenOr(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : FalseFilter.instance();
            }
            case 1: {
                return (Filter)list.get(0);
            }
        }
        if (CalciteCnfHelper.containsTrue(list)) {
            return TrueFilter.instance();
        }
        return new OrFilter((List<Filter>)list);
    }

    public static ImmutableList<Filter> flattenOr(Iterable<? extends Filter> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<Filter> set = new HashSet<Filter>();
        for (Filter filter : nodes) {
            CalciteCnfHelper.addOr((ImmutableList.Builder<Filter>)builder, set, filter);
        }
        return builder.build();
    }

    private static void addOr(ImmutableList.Builder<Filter> builder, Set<Filter> set, Filter node) {
        if (node instanceof OrFilter) {
            for (Filter operand : ((OrFilter)node).getFilters()) {
                CalciteCnfHelper.addOr(builder, set, operand);
            }
        } else if (set.add(node)) {
            builder.add((Object)node);
        }
    }

    public static List<Filter> conjunctions(Filter rexPredicate) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        CalciteCnfHelper.decomposeConjunction(rexPredicate, list);
        return list;
    }

    public static void decomposeConjunction(Filter rexPredicate, List<Filter> rexList) {
        if (rexPredicate == null || rexPredicate instanceof TrueFilter) {
            return;
        }
        if (rexPredicate instanceof AndFilter) {
            for (Filter operand : ((AndFilter)rexPredicate).getFilters()) {
                CalciteCnfHelper.decomposeConjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    private static boolean containsTrue(Iterable<Filter> nodes) {
        for (Filter node : nodes) {
            if (!(node instanceof TrueFilter)) continue;
            return true;
        }
        return false;
    }

    private CalciteCnfHelper() {
    }
}

