/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.AllNullColumnSelectorFactory;
import org.apache.druid.segment.join.filter.JoinFilterAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterColumnCorrelationAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterSplit;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;

public class JoinFilterAnalyzer {
    private static final String PUSH_DOWN_VIRTUAL_COLUMN_NAME_BASE = "JOIN-FILTER-PUSHDOWN-VIRTUAL-COLUMN-";
    private static final ColumnSelectorFactory ALL_NULL_COLUMN_SELECTOR_FACTORY = new AllNullColumnSelectorFactory();

    public static JoinFilterPreAnalysis computeJoinFilterPreAnalysis(List<JoinableClause> joinableClauses, VirtualColumns virtualColumns, Filter originalFilter, boolean enableFilterPushDown, boolean enableFilterRewrite, boolean enableRewriteValueColumnFilters, long filterRewriteMaxSize) {
        ArrayList<VirtualColumn> preJoinVirtualColumns = new ArrayList<VirtualColumn>();
        ArrayList<VirtualColumn> postJoinVirtualColumns = new ArrayList<VirtualColumn>();
        JoinFilterAnalyzer.splitVirtualColumns(joinableClauses, virtualColumns, preJoinVirtualColumns, postJoinVirtualColumns);
        if (originalFilter == null || !enableFilterPushDown) {
            return new JoinFilterPreAnalysis(joinableClauses, originalFilter, postJoinVirtualColumns, null, null, null, enableFilterPushDown, enableFilterRewrite);
        }
        Filter normalizedFilter = Filters.toCnf(originalFilter);
        Set<Filter> normalizedOrClauses = normalizedFilter instanceof AndFilter ? ((AndFilter)normalizedFilter).getFilters() : Collections.singleton(normalizedFilter);
        ArrayList<Filter> normalizedBaseTableClauses = new ArrayList<Filter>();
        ArrayList<Filter> normalizedJoinTableClauses = new ArrayList<Filter>();
        for (Filter filter : normalizedOrClauses) {
            Set<String> reqColumns = filter.getRequiredColumns();
            if (JoinFilterAnalyzer.areSomeColumnsFromJoin(joinableClauses, reqColumns) || JoinFilterAnalyzer.areSomeColumnsFromPostJoinVirtualColumns(postJoinVirtualColumns, reqColumns)) {
                normalizedJoinTableClauses.add(filter);
                continue;
            }
            normalizedBaseTableClauses.add(filter);
        }
        if (!enableFilterRewrite) {
            return new JoinFilterPreAnalysis(joinableClauses, originalFilter, postJoinVirtualColumns, normalizedBaseTableClauses, normalizedJoinTableClauses, null, enableFilterPushDown, enableFilterRewrite);
        }
        HashMap<String, Set> equiconditions = new HashMap<String, Set>();
        for (JoinableClause clause : joinableClauses) {
            for (Equality equality : clause.getCondition().getEquiConditions()) {
                Set set = equiconditions.computeIfAbsent(clause.getPrefix() + equality.getRightColumn(), rhs -> new HashSet());
                set.add(equality.getLeftExpr());
            }
        }
        HashMap<String, Optional> hashMap = new HashMap<String, Optional>();
        HashSet<RhsRewriteCandidate> rhsRewriteCandidates = new HashSet<RhsRewriteCandidate>();
        for (Filter orClause : normalizedJoinTableClauses) {
            if (JoinFilterAnalyzer.filterMatchesNull(orClause)) continue;
            if (orClause instanceof SelectorFilter) {
                String string = ((SelectorFilter)orClause).getDimension();
                String reqValue = ((SelectorFilter)orClause).getValue();
                JoinableClause joinableClause = JoinFilterAnalyzer.isColumnFromJoin(joinableClauses, string);
                if (joinableClause != null) {
                    rhsRewriteCandidates.add(new RhsRewriteCandidate(joinableClause, string, reqValue));
                }
            }
            if (!(orClause instanceof OrFilter)) continue;
            for (Filter subFilter : ((OrFilter)orClause).getFilters()) {
                if (!(subFilter instanceof SelectorFilter)) continue;
                String reqColumn = ((SelectorFilter)subFilter).getDimension();
                String reqValue = ((SelectorFilter)subFilter).getValue();
                JoinableClause joinableClause = JoinFilterAnalyzer.isColumnFromJoin(joinableClauses, reqColumn);
                if (joinableClause == null) continue;
                rhsRewriteCandidates.add(new RhsRewriteCandidate(joinableClause, reqColumn, reqValue));
            }
        }
        for (RhsRewriteCandidate rhsRewriteCandidate : rhsRewriteCandidates) {
            hashMap.computeIfAbsent(rhsRewriteCandidate.getJoinableClause().getPrefix(), p -> JoinFilterAnalyzer.findCorrelatedBaseTableColumns(joinableClauses, p, rhsRewriteCandidate.getJoinableClause(), equiconditions));
        }
        HashMap<String, Optional<List<JoinFilterColumnCorrelationAnalysis>>> correlationsByFilteringColumn = new HashMap<String, Optional<List<JoinFilterColumnCorrelationAnalysis>>>();
        for (RhsRewriteCandidate rhsRewriteCandidate : rhsRewriteCandidates) {
            Optional correlationsForPrefix = (Optional)hashMap.get(rhsRewriteCandidate.getJoinableClause().getPrefix());
            if (correlationsForPrefix.isPresent()) {
                for (Map.Entry correlationForPrefix : ((Map)correlationsForPrefix.get()).entrySet()) {
                    Optional perColumnCorrelations = correlationsByFilteringColumn.computeIfAbsent(rhsRewriteCandidate.getRhsColumn(), rhsCol -> Optional.of(new ArrayList()));
                    ((List)perColumnCorrelations.get()).add(correlationForPrefix.getValue());
                    ((JoinFilterColumnCorrelationAnalysis)correlationForPrefix.getValue()).getCorrelatedValuesMap().computeIfAbsent((Pair<String, String>)Pair.of((Object)rhsRewriteCandidate.getRhsColumn(), (Object)rhsRewriteCandidate.getValueForRewrite()), rhsVal -> {
                        Set<String> correlatedValues = JoinFilterAnalyzer.getCorrelatedValuesForPushDown(rhsRewriteCandidate.getRhsColumn(), rhsRewriteCandidate.getValueForRewrite(), ((JoinFilterColumnCorrelationAnalysis)correlationForPrefix.getValue()).getJoinColumn(), rhsRewriteCandidate.getJoinableClause(), enableRewriteValueColumnFilters, filterRewriteMaxSize);
                        if (correlatedValues.isEmpty()) {
                            return Optional.empty();
                        }
                        return Optional.of(correlatedValues);
                    });
                }
                continue;
            }
            correlationsByFilteringColumn.put(rhsRewriteCandidate.getRhsColumn(), Optional.empty());
        }
        for (Map.Entry entry : correlationsByFilteringColumn.entrySet()) {
            if (!((Optional)entry.getValue()).isPresent()) continue;
            List<JoinFilterColumnCorrelationAnalysis> dedupList = JoinFilterAnalyzer.eliminateCorrelationDuplicates((List)((Optional)entry.getValue()).get());
            correlationsByFilteringColumn.put((String)entry.getKey(), Optional.of(dedupList));
        }
        return new JoinFilterPreAnalysis(joinableClauses, originalFilter, postJoinVirtualColumns, normalizedBaseTableClauses, normalizedJoinTableClauses, correlationsByFilteringColumn, enableFilterPushDown, enableFilterRewrite);
    }

    public static JoinFilterSplit splitFilter(JoinFilterPreAnalysis joinFilterPreAnalysis) {
        if (joinFilterPreAnalysis.getOriginalFilter() == null || !joinFilterPreAnalysis.isEnableFilterPushDown()) {
            return new JoinFilterSplit(null, joinFilterPreAnalysis.getOriginalFilter(), (List<VirtualColumn>)ImmutableList.of());
        }
        ArrayList<Filter> leftFilters = new ArrayList<Filter>();
        ArrayList<Filter> rightFilters = new ArrayList<Filter>();
        ArrayList<VirtualColumn> pushDownVirtualColumns = new ArrayList<VirtualColumn>();
        for (Filter baseTableFilter : joinFilterPreAnalysis.getNormalizedBaseTableClauses()) {
            if (!JoinFilterAnalyzer.filterMatchesNull(baseTableFilter)) {
                leftFilters.add(baseTableFilter);
                continue;
            }
            rightFilters.add(baseTableFilter);
        }
        for (Filter orClause : joinFilterPreAnalysis.getNormalizedJoinTableClauses()) {
            JoinFilterAnalysis joinFilterAnalysis = JoinFilterAnalyzer.analyzeJoinFilterClause(orClause, joinFilterPreAnalysis);
            if (joinFilterAnalysis.isCanPushDown()) {
                leftFilters.add(joinFilterAnalysis.getPushDownFilter().get());
                if (!joinFilterAnalysis.getPushDownVirtualColumns().isEmpty()) {
                    pushDownVirtualColumns.addAll(joinFilterAnalysis.getPushDownVirtualColumns());
                }
            }
            if (!joinFilterAnalysis.isRetainAfterJoin()) continue;
            rightFilters.add(joinFilterAnalysis.getOriginalFilter());
        }
        return new JoinFilterSplit(Filters.and(leftFilters), Filters.and(rightFilters), pushDownVirtualColumns);
    }

    private static JoinFilterAnalysis analyzeJoinFilterClause(Filter filterClause, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        if (!joinFilterPreAnalysis.isEnableFilterRewrite() || JoinFilterAnalyzer.filterMatchesNull(filterClause)) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
        }
        if (filterClause instanceof SelectorFilter) {
            return JoinFilterAnalyzer.rewriteSelectorFilter((SelectorFilter)filterClause, joinFilterPreAnalysis);
        }
        if (filterClause instanceof OrFilter) {
            return JoinFilterAnalyzer.rewriteOrFilter((OrFilter)filterClause, joinFilterPreAnalysis);
        }
        return JoinFilterAnalysis.createNoPushdownFilterAnalysis(filterClause);
    }

    private static JoinFilterAnalysis rewriteOrFilter(OrFilter orFilter, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        boolean retainRhs = false;
        HashSet<Filter> newFilters = new HashSet<Filter>();
        for (Filter filter : orFilter.getFilters()) {
            if (!JoinFilterAnalyzer.areSomeColumnsFromJoin(joinFilterPreAnalysis.getJoinableClauses(), filter.getRequiredColumns())) {
                newFilters.add(filter);
                continue;
            }
            retainRhs = true;
            if (filter instanceof SelectorFilter) {
                JoinFilterAnalysis rewritten = JoinFilterAnalyzer.rewriteSelectorFilter((SelectorFilter)filter, joinFilterPreAnalysis);
                if (!rewritten.isCanPushDown()) {
                    return JoinFilterAnalysis.createNoPushdownFilterAnalysis(orFilter);
                }
                newFilters.add(rewritten.getPushDownFilter().get());
                continue;
            }
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(orFilter);
        }
        return new JoinFilterAnalysis(retainRhs, orFilter, new OrFilter(newFilters), (List<VirtualColumn>)ImmutableList.of());
    }

    private static JoinFilterAnalysis rewriteSelectorFilter(SelectorFilter selectorFilter, JoinFilterPreAnalysis joinFilterPreAnalysis) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        ArrayList<VirtualColumn> pushdownVirtualColumns = new ArrayList<VirtualColumn>();
        String filteringColumn = selectorFilter.getDimension();
        String filteringValue = selectorFilter.getValue();
        if (JoinFilterAnalyzer.areSomeColumnsFromPostJoinVirtualColumns(joinFilterPreAnalysis.getPostJoinVirtualColumns(), selectorFilter.getRequiredColumns())) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
        }
        if (!JoinFilterAnalyzer.areSomeColumnsFromJoin(joinFilterPreAnalysis.getJoinableClauses(), selectorFilter.getRequiredColumns())) {
            return new JoinFilterAnalysis(true, selectorFilter, selectorFilter, pushdownVirtualColumns);
        }
        Optional<List<JoinFilterColumnCorrelationAnalysis>> correlationAnalyses = joinFilterPreAnalysis.getCorrelationsByFilteringColumn().get(filteringColumn);
        if (!correlationAnalyses.isPresent()) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
        }
        for (JoinFilterColumnCorrelationAnalysis correlationAnalysis : correlationAnalyses.get()) {
            if (!correlationAnalysis.supportsPushDown()) continue;
            Optional<Set<String>> correlatedValues = correlationAnalysis.getCorrelatedValuesMap().get(Pair.of((Object)filteringColumn, (Object)filteringValue));
            if (!correlatedValues.isPresent()) {
                return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
            }
            for (String correlatedBaseColumn : correlationAnalysis.getBaseColumns()) {
                Filter rewrittenFilter = new InDimFilter(correlatedBaseColumn, (Collection<String>)correlatedValues.get(), null, null).toFilter();
                newFilters.add(rewrittenFilter);
            }
            for (Expr correlatedBaseExpr : correlationAnalysis.getBaseExpressions()) {
                String vcName = JoinFilterAnalyzer.getCorrelatedBaseExprVirtualColumnName(pushdownVirtualColumns.size());
                ExpressionVirtualColumn correlatedBaseExprVirtualColumn = new ExpressionVirtualColumn(vcName, correlatedBaseExpr, ValueType.STRING);
                pushdownVirtualColumns.add(correlatedBaseExprVirtualColumn);
                Filter rewrittenFilter = new InDimFilter(vcName, (Collection<String>)correlatedValues.get(), null, null).toFilter();
                newFilters.add(rewrittenFilter);
            }
        }
        if (newFilters.isEmpty()) {
            return JoinFilterAnalysis.createNoPushdownFilterAnalysis(selectorFilter);
        }
        return new JoinFilterAnalysis(true, selectorFilter, Filters.and(newFilters), pushdownVirtualColumns);
    }

    private static String getCorrelatedBaseExprVirtualColumnName(int counter) {
        return PUSH_DOWN_VIRTUAL_COLUMN_NAME_BASE + counter;
    }

    private static Set<String> getCorrelatedValuesForPushDown(String filterColumn, String filterValue, String correlatedJoinColumn, JoinableClause clauseForFilteredTable, boolean enableRewriteValueColumnFilters, long filterRewriteMaxSize) {
        String filterColumnNoPrefix = filterColumn.substring(clauseForFilteredTable.getPrefix().length());
        String correlatedColumnNoPrefix = correlatedJoinColumn.substring(clauseForFilteredTable.getPrefix().length());
        return clauseForFilteredTable.getJoinable().getCorrelatedColumnValues(filterColumnNoPrefix, filterValue, correlatedColumnNoPrefix, filterRewriteMaxSize, enableRewriteValueColumnFilters);
    }

    private static Optional<Map<String, JoinFilterColumnCorrelationAnalysis>> findCorrelatedBaseTableColumns(List<JoinableClause> joinableClauses, String tablePrefix, JoinableClause clauseForTablePrefix, Map<String, Set<Expr>> equiConditions) {
        JoinConditionAnalysis jca = clauseForTablePrefix.getCondition();
        HashSet<String> rhsColumns = new HashSet<String>();
        for (Equality eq : jca.getEquiConditions()) {
            rhsColumns.add(tablePrefix + eq.getRightColumn());
        }
        HashMap<String, JoinFilterColumnCorrelationAnalysis> correlations = new HashMap<String, JoinFilterColumnCorrelationAnalysis>();
        for (String rhsColumn : rhsColumns) {
            HashSet<String> correlatedBaseColumns = new HashSet<String>();
            HashSet<Expr> correlatedBaseExpressions = new HashSet<Expr>();
            JoinFilterAnalyzer.getCorrelationForRHSColumn(joinableClauses, equiConditions, rhsColumn, correlatedBaseColumns, correlatedBaseExpressions);
            if (correlatedBaseColumns.isEmpty() && correlatedBaseExpressions.isEmpty()) continue;
            correlations.put(rhsColumn, new JoinFilterColumnCorrelationAnalysis(rhsColumn, correlatedBaseColumns, correlatedBaseExpressions));
        }
        if (correlations.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(correlations);
    }

    private static void getCorrelationForRHSColumn(List<JoinableClause> joinableClauses, Map<String, Set<Expr>> equiConditions, String rhsColumn, Set<String> correlatedBaseColumns, Set<Expr> correlatedBaseExpressions) {
        String findMappingFor = rhsColumn;
        Set<Expr> lhsExprs = equiConditions.get(findMappingFor);
        if (lhsExprs == null) {
            return;
        }
        for (Expr lhsExpr : lhsExprs) {
            String identifier = lhsExpr.getBindingIfIdentifier();
            if (identifier == null) {
                Expr.BindingDetails bindingDetails = lhsExpr.analyzeInputs();
                Set requiredBindings = bindingDetails.getRequiredBindings();
                if (JoinFilterAnalyzer.areSomeColumnsFromJoin(joinableClauses, requiredBindings)) break;
                correlatedBaseExpressions.add(lhsExpr);
                continue;
            }
            findMappingFor = identifier;
            if (JoinFilterAnalyzer.isColumnFromJoin(joinableClauses, identifier) == null) {
                correlatedBaseColumns.add(findMappingFor);
                continue;
            }
            JoinFilterAnalyzer.getCorrelationForRHSColumn(joinableClauses, equiConditions, findMappingFor, correlatedBaseColumns, correlatedBaseExpressions);
        }
    }

    private static List<JoinFilterColumnCorrelationAnalysis> eliminateCorrelationDuplicates(List<JoinFilterColumnCorrelationAnalysis> originalList) {
        HashMap<List<String>, JoinFilterColumnCorrelationAnalysis> uniquesMap = new HashMap<List<String>, JoinFilterColumnCorrelationAnalysis>();
        for (JoinFilterColumnCorrelationAnalysis jca : originalList) {
            uniquesMap.put(jca.getBaseColumns(), jca);
        }
        return new ArrayList<JoinFilterColumnCorrelationAnalysis>(uniquesMap.values());
    }

    private static boolean filterMatchesNull(Filter filter) {
        ValueMatcher valueMatcher = filter.makeMatcher(ALL_NULL_COLUMN_SELECTOR_FACTORY);
        return valueMatcher.matches();
    }

    @Nullable
    private static JoinableClause isColumnFromJoin(List<JoinableClause> joinableClauses, String column) {
        for (JoinableClause joinableClause : joinableClauses) {
            if (!joinableClause.includesColumn(column)) continue;
            return joinableClause;
        }
        return null;
    }

    private static boolean isColumnFromPostJoinVirtualColumns(List<VirtualColumn> postJoinVirtualColumns, String column) {
        for (VirtualColumn postJoinVirtualColumn : postJoinVirtualColumns) {
            if (!column.equals(postJoinVirtualColumn.getOutputName())) continue;
            return true;
        }
        return false;
    }

    private static boolean areSomeColumnsFromJoin(List<JoinableClause> joinableClauses, Collection<String> columns) {
        for (String column : columns) {
            if (JoinFilterAnalyzer.isColumnFromJoin(joinableClauses, column) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean areSomeColumnsFromPostJoinVirtualColumns(List<VirtualColumn> postJoinVirtualColumns, Collection<String> columns) {
        for (String column : columns) {
            if (!JoinFilterAnalyzer.isColumnFromPostJoinVirtualColumns(postJoinVirtualColumns, column)) continue;
            return true;
        }
        return false;
    }

    private static void splitVirtualColumns(List<JoinableClause> joinableClauses, VirtualColumns virtualColumns, List<VirtualColumn> preJoinVirtualColumns, List<VirtualColumn> postJoinVirtualColumns) {
        for (VirtualColumn virtualColumn : virtualColumns.getVirtualColumns()) {
            if (JoinFilterAnalyzer.areSomeColumnsFromJoin(joinableClauses, virtualColumn.requiredColumns())) {
                postJoinVirtualColumns.add(virtualColumn);
                continue;
            }
            preJoinVirtualColumns.add(virtualColumn);
        }
    }

    private static class RhsRewriteCandidate {
        private final JoinableClause joinableClause;
        private final String rhsColumn;
        private final String valueForRewrite;

        public RhsRewriteCandidate(JoinableClause joinableClause, String rhsColumn, String valueForRewrite) {
            this.joinableClause = joinableClause;
            this.rhsColumn = rhsColumn;
            this.valueForRewrite = valueForRewrite;
        }

        public JoinableClause getJoinableClause() {
            return this.joinableClause;
        }

        public String getRhsColumn() {
            return this.rhsColumn;
        }

        public String getValueForRewrite() {
            return this.valueForRewrite;
        }
    }
}

