/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterColumnCorrelationAnalysis;

public class JoinFilterPreAnalysis {
    private final List<JoinableClause> joinableClauses;
    private final Filter originalFilter;
    private final List<Filter> normalizedBaseTableClauses;
    private final List<Filter> normalizedJoinTableClauses;
    private final Map<String, Optional<List<JoinFilterColumnCorrelationAnalysis>>> correlationsByFilteringColumn;
    private final boolean enableFilterPushDown;
    private final boolean enableFilterRewrite;
    private final List<VirtualColumn> postJoinVirtualColumns;

    public JoinFilterPreAnalysis(List<JoinableClause> joinableClauses, Filter originalFilter, List<VirtualColumn> postJoinVirtualColumns, List<Filter> normalizedBaseTableClauses, List<Filter> normalizedJoinTableClauses, Map<String, Optional<List<JoinFilterColumnCorrelationAnalysis>>> correlationsByFilteringColumn, boolean enableFilterPushDown, boolean enableFilterRewrite) {
        this.joinableClauses = joinableClauses;
        this.originalFilter = originalFilter;
        this.postJoinVirtualColumns = postJoinVirtualColumns;
        this.normalizedBaseTableClauses = normalizedBaseTableClauses;
        this.normalizedJoinTableClauses = normalizedJoinTableClauses;
        this.correlationsByFilteringColumn = correlationsByFilteringColumn;
        this.enableFilterPushDown = enableFilterPushDown;
        this.enableFilterRewrite = enableFilterRewrite;
    }

    public List<JoinableClause> getJoinableClauses() {
        return this.joinableClauses;
    }

    public Filter getOriginalFilter() {
        return this.originalFilter;
    }

    public List<VirtualColumn> getPostJoinVirtualColumns() {
        return this.postJoinVirtualColumns;
    }

    public List<Filter> getNormalizedBaseTableClauses() {
        return this.normalizedBaseTableClauses;
    }

    public List<Filter> getNormalizedJoinTableClauses() {
        return this.normalizedJoinTableClauses;
    }

    public Map<String, Optional<List<JoinFilterColumnCorrelationAnalysis>>> getCorrelationsByFilteringColumn() {
        return this.correlationsByFilteringColumn;
    }

    public boolean isEnableFilterPushDown() {
        return this.enableFilterPushDown;
    }

    public boolean isEnableFilterRewrite() {
        return this.enableFilterRewrite;
    }
}

