/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.lookup.LookupJoinMatcher;

public class LookupJoinable
implements Joinable {
    static final List<String> ALL_COLUMNS = ImmutableList.of((Object)"k", (Object)"v");
    private final LookupExtractor extractor;

    private LookupJoinable(LookupExtractor extractor) {
        this.extractor = extractor;
    }

    public static LookupJoinable wrap(LookupExtractor extractor) {
        return new LookupJoinable(extractor);
    }

    @Override
    public List<String> getAvailableColumns() {
        return ALL_COLUMNS;
    }

    @Override
    public int getCardinality(String columnName) {
        return -1;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (ALL_COLUMNS.contains(columnName)) {
            return new ColumnCapabilitiesImpl().setType(ValueType.STRING);
        }
        return null;
    }

    @Override
    public JoinMatcher makeJoinMatcher(ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded) {
        return LookupJoinMatcher.create(this.extractor, leftSelectorFactory, condition, remainderNeeded);
    }

    @Override
    public Set<String> getCorrelatedColumnValues(String searchColumnName, String searchColumnValue, String retrievalColumnName, long maxCorrelationSetSize, boolean allowNonKeyColumnSearch) {
        Object correlatedValues;
        if (!ALL_COLUMNS.contains(searchColumnName) || !ALL_COLUMNS.contains(retrievalColumnName)) {
            return ImmutableSet.of();
        }
        if ("k".equals(searchColumnName)) {
            correlatedValues = "k".equals(retrievalColumnName) ? ImmutableSet.of((Object)searchColumnValue) : Collections.singleton(this.extractor.apply(searchColumnValue));
        } else {
            if (!allowNonKeyColumnSearch) {
                return ImmutableSet.of();
            }
            correlatedValues = "v".equals(retrievalColumnName) ? ImmutableSet.of((Object)searchColumnValue) : ImmutableSet.copyOf(this.extractor.unapply(searchColumnValue));
        }
        return correlatedValues;
    }
}

